/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import liquibase.database.template.PreparedStatementSetter;
import liquibase.database.template.SqlParameterValue;
import liquibase.database.template.StatementCreatorUtils;

class ArgPreparedStatementSetter
implements PreparedStatementSetter {
    private final Object[] args;

    public ArgPreparedStatementSetter(Object[] objectArray) {
        this.args = objectArray;
    }

    public void setValues(PreparedStatement preparedStatement) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object object = this.args[i];
                if (object instanceof SqlParameterValue) {
                    SqlParameterValue sqlParameterValue = (SqlParameterValue)object;
                    StatementCreatorUtils.setParameterValue(preparedStatement, i + 1, sqlParameterValue, sqlParameterValue.getValue());
                    continue;
                }
                StatementCreatorUtils.setParameterValue(preparedStatement, i + 1, Integer.MIN_VALUE, object);
            }
        }
    }
}

