/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements DatabaseObject,
Comparable<Table> {
    private Database database;
    private String name;
    private String remarks;
    private String schema;
    private List<Column> columns = new ArrayList<Column>();

    public Table(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Table table = (Table)object;
        return this.name.equalsIgnoreCase(table.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    @Override
    public int compareTo(Table table) {
        return this.getName().compareToIgnoreCase(table.getName());
    }

    public String toString() {
        return this.getName();
    }

    public Column getColumn(String string) {
        for (Column column : this.getColumns()) {
            if (!column.getName().equalsIgnoreCase(string)) continue;
            return column;
        }
        return null;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }
}

