/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlDatabaseSnapshot
implements DatabaseSnapshot {
    protected DatabaseMetaData databaseMetaData;
    protected Database database;
    protected Set<Table> tables = new HashSet<Table>();
    protected Set<View> views = new HashSet<View>();
    protected Set<Column> columns = new HashSet<Column>();
    protected Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    protected Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    protected Set<Index> indexes = new HashSet<Index>();
    protected Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    protected Set<Sequence> sequences = new HashSet<Sequence>();
    protected Map<String, Table> tablesMap = new HashMap<String, Table>();
    protected Map<String, View> viewsMap = new HashMap<String, View>();
    protected Map<String, Column> columnsMap = new HashMap<String, Column>();
    private Set<DiffStatusListener> statusListeners;
    protected static final Logger log = LogFactory.getLogger();
    private String schema;
    private boolean hasDatabaseChangeLogTable = false;

    public SqlDatabaseSnapshot() {
    }

    public SqlDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public SqlDatabaseSnapshot(Database database, String string) throws JDBCException {
        this(database, null, string);
    }

    public SqlDatabaseSnapshot(Database database, Set<DiffStatusListener> set) throws JDBCException {
        this(database, set, database.getDefaultSchemaName());
    }

    public SqlDatabaseSnapshot(Database database, Set<DiffStatusListener> set, String string) throws JDBCException {
        if (string == null) {
            string = database.getDefaultSchemaName();
        }
        try {
            this.schema = string;
            this.database = database;
            this.databaseMetaData = database.getConnection().getMetaData();
            this.statusListeners = set;
            this.readTablesAndViews(string);
            this.readForeignKeyInformation(string);
            this.readPrimaryKeys(string);
            this.readColumns(string);
            this.readUniqueConstraints(string);
            this.readIndexes(string);
            this.readSequences(string);
            this.tables = new HashSet<Table>(this.tablesMap.values());
            this.views = new HashSet<View>(this.viewsMap.values());
            this.columns = new HashSet<Column>(this.columnsMap.values());
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    @Override
    public Set<View> getViews() {
        return this.views;
    }

    @Override
    public Column getColumn(Column column) {
        if (column.getTable() == null) {
            return this.getColumn(column.getView().getName(), column.getName());
        }
        return this.getColumn(column.getTable().getName(), column.getName());
    }

    @Override
    public Column getColumn(String string, String string2) {
        String string3 = string + "." + string2;
        Column column = this.columnsMap.get(string3);
        if (column == null) {
            for (String string4 : this.columnsMap.keySet()) {
                if (!string4.equalsIgnoreCase(string3)) continue;
                return this.columnsMap.get(string4);
            }
        }
        return column;
    }

    @Override
    public Set<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public Set<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    protected void readTablesAndViews(String string) throws SQLException, JDBCException {
        this.updateListeners("Reading tables for " + this.database.toString() + " ...");
        ResultSet resultSet = this.databaseMetaData.getTables(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), null, new String[]{"TABLE", "VIEW", "ALIAS"});
        while (resultSet.next()) {
            DatabaseObject databaseObject;
            String string2 = resultSet.getString("TABLE_TYPE");
            String string3 = this.convertFromDatabaseName(resultSet.getString("TABLE_NAME"));
            String string4 = this.convertFromDatabaseName(resultSet.getString("TABLE_SCHEM"));
            String string5 = this.convertFromDatabaseName(resultSet.getString("TABLE_CAT"));
            String string6 = resultSet.getString("REMARKS");
            if (this.database.isSystemTable(string5, string4, string3) || this.database.isLiquibaseTable(string3) || this.database.isSystemView(string5, string4, string3)) {
                if (!string3.equalsIgnoreCase(this.database.getDatabaseChangeLogTableName())) continue;
                this.hasDatabaseChangeLogTable = true;
                continue;
            }
            if ("TABLE".equals(string2) || "ALIAS".equals(string2)) {
                databaseObject = new Table(string3);
                ((Table)databaseObject).setRemarks(StringUtils.trimToNull(string6));
                ((Table)databaseObject).setDatabase(this.database);
                ((Table)databaseObject).setSchema(string4);
                this.tablesMap.put(string3, (Table)databaseObject);
                continue;
            }
            if (!"VIEW".equals(string2)) continue;
            databaseObject = new View();
            ((View)databaseObject).setName(string3);
            ((View)databaseObject).setSchema(string4);
            try {
                ((View)databaseObject).setDefinition(this.database.getViewDefinition(string, string3));
            }
            catch (JDBCException jDBCException) {
                System.out.println("Error getting " + this.database.getConnectionURL() + " view with " + ((AbstractDatabase)this.database).getViewDefinitionSql(string, string3));
                throw jDBCException;
            }
            this.viewsMap.put(string3, (View)databaseObject);
        }
        resultSet.close();
    }

    protected String convertFromDatabaseName(String string) {
        if (string == null) {
            return null;
        }
        return string;
    }

    protected void readColumns(String string) throws SQLException, JDBCException {
        this.updateListeners("Reading columns for " + this.database.toString() + " ...");
        Statement statement = this.database.getConnection().createStatement();
        ResultSet resultSet = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), null, null);
        while (resultSet.next()) {
            Column column = new Column();
            String string2 = this.convertFromDatabaseName(resultSet.getString("TABLE_NAME"));
            String string3 = this.convertFromDatabaseName(resultSet.getString("COLUMN_NAME"));
            String string4 = this.convertFromDatabaseName(resultSet.getString("TABLE_SCHEM"));
            String string5 = this.convertFromDatabaseName(resultSet.getString("TABLE_CAT"));
            String string6 = resultSet.getString("REMARKS");
            if (this.database.isSystemTable(string5, string4, string2) || this.database.isLiquibaseTable(string2)) continue;
            Table table = this.tablesMap.get(string2);
            if (table == null) {
                View view = this.viewsMap.get(string2);
                if (view == null) {
                    log.fine("Could not find table or view " + string2 + " for column " + string3);
                    continue;
                }
                column.setView(view);
                view.getColumns().add(column);
            } else {
                column.setTable(table);
                table.getColumns().add(column);
            }
            column.setName(string3);
            column.setDataType(resultSet.getInt("DATA_TYPE"));
            column.setColumnSize(resultSet.getInt("COLUMN_SIZE"));
            column.setDecimalDigits(resultSet.getInt("DECIMAL_DIGITS"));
            int n = resultSet.getInt("NULLABLE");
            if (n == 0) {
                column.setNullable(false);
            } else if (n == 1) {
                column.setNullable(true);
            }
            column.setPrimaryKey(this.isPrimaryKey(column));
            column.setAutoIncrement(this.database.isColumnAutoIncrement(string, string2, string3));
            this.getColumnTypeAndDefValue(column, resultSet, this.database);
            column.setRemarks(string6);
            this.columnsMap.put(string2 + "." + string3, column);
        }
        resultSet.close();
        statement.close();
    }

    protected void getColumnTypeAndDefValue(Column column, ResultSet resultSet, Database database) throws SQLException, JDBCException {
        Object object = resultSet.getObject("COLUMN_DEF");
        try {
            column.setDefaultValue(database.convertDatabaseValueToJavaObject(object, column.getDataType(), column.getColumnSize(), column.getDecimalDigits()));
        }
        catch (ParseException parseException) {
            throw new JDBCException(parseException);
        }
        column.setTypeName(database.getColumnType(resultSet.getString("TYPE_NAME"), column.isAutoIncrement()));
    }

    protected boolean isPrimaryKey(Column column) {
        for (PrimaryKey primaryKey : this.getPrimaryKeys()) {
            if (column.getTable() == null || !primaryKey.getTable().getName().equalsIgnoreCase(column.getTable().getName()) || !primaryKey.getColumnNamesAsList().contains(column.getName())) continue;
            return true;
        }
        return false;
    }

    protected void readForeignKeyInformation(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading foreign keys for " + this.database.toString() + " ...");
        for (Table table : this.tablesMap.values()) {
            String string2 = this.database.convertRequestedSchemaToCatalog(string);
            String string3 = this.database.convertRequestedSchemaToSchema(string);
            ResultSet resultSet = this.databaseMetaData.getExportedKeys(string2, string3, table.getName());
            ForeignKey foreignKey = null;
            while (resultSet.next()) {
                String string4 = this.convertFromDatabaseName(resultSet.getString("FK_NAME"));
                String string5 = this.convertFromDatabaseName(resultSet.getString("PKTABLE_NAME"));
                String string6 = this.convertFromDatabaseName(resultSet.getString("PKCOLUMN_NAME"));
                Table table2 = this.tablesMap.get(string5);
                if (table2 == null) {
                    log.warning("Foreign key " + string4 + " references table " + string5 + ", which we cannot find.  Ignoring.");
                    continue;
                }
                int n = resultSet.getInt("KEY_SEQ");
                if (n == 1) {
                    foreignKey = new ForeignKey();
                }
                foreignKey.setPrimaryKeyTable(table2);
                foreignKey.addPrimaryKeyColumn(string6);
                String string7 = this.convertFromDatabaseName(resultSet.getString("FKTABLE_NAME"));
                String string8 = this.convertFromDatabaseName(resultSet.getString("FKTABLE_SCHEM"));
                String string9 = this.convertFromDatabaseName(resultSet.getString("FKCOLUMN_NAME"));
                Table table3 = this.tablesMap.get(string7);
                if (table3 == null) {
                    table3 = new Table(string7);
                    table3.setDatabase(this.database);
                    table3.setSchema(string8);
                    log.warning("Foreign key " + string4 + " is in table " + string7 + ", which is in a different schema.  Retaining FK in diff, but table will not be diffed.");
                }
                foreignKey.setForeignKeyTable(table3);
                foreignKey.addForeignKeyColumn(string9);
                foreignKey.setName(string4);
                Integer n2 = resultSet.getInt("UPDATE_RULE");
                if (resultSet.wasNull()) {
                    n2 = null;
                }
                Integer n3 = resultSet.getInt("DELETE_RULE");
                if (resultSet.wasNull()) {
                    n3 = null;
                }
                foreignKey.setUpdateRule(n2);
                foreignKey.setDeleteRule(n3);
                if (this.database.supportsInitiallyDeferrableColumns()) {
                    short s = resultSet.getShort("DEFERRABILITY");
                    if (s == 5) {
                        foreignKey.setDeferrable(Boolean.TRUE);
                        foreignKey.setInitiallyDeferred(Boolean.TRUE);
                    } else if (s == 6) {
                        foreignKey.setDeferrable(Boolean.TRUE);
                        foreignKey.setInitiallyDeferred(Boolean.FALSE);
                    } else if (s == 7) {
                        foreignKey.setDeferrable(Boolean.FALSE);
                        foreignKey.setInitiallyDeferred(Boolean.FALSE);
                    }
                }
                if (n != 1) continue;
                this.foreignKeys.add(foreignKey);
            }
            resultSet.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readIndexes(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading indexes for " + this.database.toString() + " ...");
        for (Table object : this.tablesMap.values()) {
            void var4_5;
            Iterator<DatabaseObject> iterator = null;
            if (this.database instanceof OracleDatabase) {
                iterator = this.database.getConnection().createStatement();
                String string2 = "SELECT INDEX_NAME, 3 AS TYPE, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION AS ORDINAL_POSITION, null AS FILTER_CONDITION FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='" + this.database.convertRequestedSchemaToSchema(string) + "' AND TABLE_NAME='" + object.getName() + "' ORDER BY INDEX_NAME, ORDINAL_POSITION";
                ResultSet resultSet = iterator.executeQuery(string2);
            } else {
                ResultSet resultSet = this.databaseMetaData.getIndexInfo(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), object.getName(), false, true);
            }
            HashMap<Object, Index> hashMap = new HashMap<Object, Index>();
            while (var4_5.next()) {
                Index index;
                String string3 = this.convertFromDatabaseName(var4_5.getString("INDEX_NAME"));
                short s = var4_5.getShort("TYPE");
                boolean bl = true;
                try {
                    bl = var4_5.getBoolean("NON_UNIQUE");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                String string4 = this.convertFromDatabaseName(var4_5.getString("COLUMN_NAME"));
                short s2 = var4_5.getShort("ORDINAL_POSITION");
                String string5 = var4_5.getString("FILTER_CONDITION");
                if (s == 0 || string4 == null) continue;
                if (hashMap.containsKey(string3)) {
                    index = (Index)hashMap.get(string3);
                } else {
                    index = new Index();
                    index.setTable(object);
                    index.setName(string3);
                    index.setUnique(!bl);
                    index.setFilterCondition(string5);
                    hashMap.put(string3, index);
                }
                for (int i = index.getColumns().size(); i < s2; ++i) {
                    index.getColumns().add(null);
                }
                index.getColumns().set(s2 - 1, string4);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.indexes.add((Index)entry.getValue());
            }
            var4_5.close();
            if (iterator == null) continue;
            iterator.close();
        }
        HashSet hashSet = new HashSet();
        for (Index index : this.indexes) {
            for (PrimaryKey primaryKey : this.primaryKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(primaryKey.getTable().getName()) || !index.getColumnNames().equals(primaryKey.getColumnNames())) continue;
                hashSet.add(index);
            }
            for (ForeignKey foreignKey : this.foreignKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(foreignKey.getForeignKeyTable().getName()) || !index.getColumnNames().equals(foreignKey.getForeignKeyColumns())) continue;
                hashSet.add(index);
            }
            for (UniqueConstraint uniqueConstraint : this.uniqueConstraints) {
                if (!index.getTable().getName().equalsIgnoreCase(uniqueConstraint.getTable().getName()) || !index.getColumnNames().equals(uniqueConstraint.getColumnNames())) continue;
                hashSet.add(index);
            }
        }
        this.indexes.removeAll(hashSet);
    }

    protected void readPrimaryKeys(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading primary keys for " + this.database.toString() + " ...");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Table table : this.tablesMap.values()) {
            ResultSet resultSet = this.databaseMetaData.getPrimaryKeys(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), table.getName());
            while (resultSet.next()) {
                String string2 = this.convertFromDatabaseName(resultSet.getString("TABLE_NAME"));
                String string3 = this.convertFromDatabaseName(resultSet.getString("COLUMN_NAME"));
                short s = resultSet.getShort("KEY_SEQ");
                boolean bl = false;
                for (PrimaryKey primaryKey : arrayList) {
                    if (!primaryKey.getTable().getName().equals(string2)) continue;
                    primaryKey.addColumnName(s - 1, string3);
                    bl = true;
                }
                if (bl) continue;
                PrimaryKey primaryKey = new PrimaryKey();
                primaryKey.setTable(table);
                primaryKey.addColumnName(s - 1, string3);
                primaryKey.setName(this.convertPrimaryKeyName(resultSet.getString("PK_NAME")));
                arrayList.add(primaryKey);
            }
            resultSet.close();
        }
        this.primaryKeys.addAll(arrayList);
    }

    protected String convertPrimaryKeyName(String string) throws SQLException {
        return string;
    }

    protected void readUniqueConstraints(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading unique constraints for " + this.database.toString() + " ...");
    }

    protected void readSequences(String string) throws JDBCException {
        List list;
        this.updateListeners("Reading sequences for " + this.database.toString() + " ...");
        String string2 = this.database.convertRequestedSchemaToSchema(string);
        if (this.database.supportsSequences() && (list = this.database.getJdbcTemplate().queryForList(this.database.createFindSequencesSQL(string), String.class, new ArrayList<SqlVisitor>())) != null) {
            for (String string3 : list) {
                Sequence sequence = new Sequence();
                sequence.setName(string3.trim());
                sequence.setSchema(string2);
                this.sequences.add(sequence);
            }
        }
    }

    protected void updateListeners(String string) {
        if (this.statusListeners == null) {
            return;
        }
        log.finest(string);
        for (DiffStatusListener diffStatusListener : this.statusListeners) {
            diffStatusListener.statusUpdate(string);
        }
    }

    @Override
    public Table getTable(String string) {
        for (Table table : this.getTables()) {
            if (!table.getName().equalsIgnoreCase(string)) continue;
            return table;
        }
        return null;
    }

    @Override
    public ForeignKey getForeignKey(String string) {
        for (ForeignKey foreignKey : this.getForeignKeys()) {
            if (!foreignKey.getName().equalsIgnoreCase(string)) continue;
            return foreignKey;
        }
        return null;
    }

    @Override
    public Sequence getSequence(String string) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equalsIgnoreCase(string)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public Index getIndex(String string) {
        for (Index index : this.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(string)) continue;
            return index;
        }
        return null;
    }

    @Override
    public View getView(String string) {
        for (View view : this.getViews()) {
            if (!view.getName().equalsIgnoreCase(string)) continue;
            return view;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKey(String string) {
        for (PrimaryKey primaryKey : this.getPrimaryKeys()) {
            if (!primaryKey.getName().equalsIgnoreCase(string)) continue;
            return primaryKey;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKeyForTable(String string) {
        for (PrimaryKey primaryKey : this.getPrimaryKeys()) {
            if (!primaryKey.getTable().getName().equalsIgnoreCase(string)) continue;
            return primaryKey;
        }
        return null;
    }

    @Override
    public UniqueConstraint getUniqueConstraint(String string) {
        for (UniqueConstraint uniqueConstraint : this.getUniqueConstraints()) {
            if (!uniqueConstraint.getName().equalsIgnoreCase(string)) continue;
            return uniqueConstraint;
        }
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() {
        return this.hasDatabaseChangeLogTable;
    }
}

