/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabaseSnapshot
extends SqlDatabaseSnapshot {
    private Logger log;

    public SQLiteDatabaseSnapshot() {
        this.log = LogFactory.getLogger();
    }

    public SQLiteDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public SQLiteDatabaseSnapshot(Database database, String string) throws JDBCException {
        this(database, null, string);
    }

    public SQLiteDatabaseSnapshot(Database database, Set<DiffStatusListener> set) throws JDBCException {
        this(database, set, database.getDefaultSchemaName());
    }

    public SQLiteDatabaseSnapshot(Database database, Set<DiffStatusListener> set, String string) throws JDBCException {
        super(database, set, string);
    }

    @Override
    protected void readTablesAndViews(String string) throws SQLException, JDBCException {
        this.updateListeners("Reading tables for " + this.database.toString() + " ...");
        ResultSet resultSet = this.databaseMetaData.getTables(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), null, new String[]{"TABLE", "VIEW"});
        while (resultSet.next()) {
            DatabaseObject databaseObject;
            String string2 = resultSet.getString("TABLE_TYPE");
            String string3 = resultSet.getString("TABLE_NAME");
            String string4 = resultSet.getString("TABLE_SCHEM");
            String string5 = resultSet.getString("TABLE_CAT");
            String string6 = resultSet.getString("REMARKS");
            if (this.database.isSystemTable(string5, string4, string3) || this.database.isLiquibaseTable(string3) || this.database.isSystemView(string5, string4, string3)) continue;
            if ("TABLE".equals(string2)) {
                databaseObject = new Table(string3);
                ((Table)databaseObject).setRemarks(StringUtils.trimToNull(string6));
                ((Table)databaseObject).setDatabase(this.database);
                ((Table)databaseObject).setSchema(string4);
                this.tablesMap.put(string3, databaseObject);
                continue;
            }
            if (!"VIEW".equals(string2)) continue;
            databaseObject = new View();
            ((View)databaseObject).setName(string3);
            ((View)databaseObject).setSchema(string4);
            try {
                ((View)databaseObject).setDefinition(this.database.getViewDefinition(string, string3));
            }
            catch (JDBCException jDBCException) {
                this.log.log(Level.SEVERE, "Error getting view with " + ((AbstractDatabase)this.database).getViewDefinitionSql(string, string3), jDBCException);
                throw jDBCException;
            }
            this.viewsMap.put(string3, databaseObject);
        }
        resultSet.close();
    }

    @Override
    protected void readForeignKeyInformation(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading foreign keys for " + this.database.toString() + " ...");
    }

    @Override
    protected void readPrimaryKeys(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading primary keys for " + this.database.toString() + " ...");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Table table : this.tablesMap.values()) {
            ResultSet resultSet = this.databaseMetaData.getPrimaryKeys(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), table.getName());
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                String string3 = resultSet.getString("COLUMN_NAME");
                short s = resultSet.getShort("KEY_SEQ");
                if (!(this.database instanceof SQLiteDatabase)) {
                    s = (short)(s - 1);
                }
                boolean bl = false;
                for (PrimaryKey primaryKey : arrayList) {
                    if (!primaryKey.getTable().getName().equals(string2)) continue;
                    primaryKey.addColumnName(s, string3);
                    bl = true;
                }
                if (bl) continue;
                PrimaryKey primaryKey = new PrimaryKey();
                primaryKey.setTable(table);
                primaryKey.addColumnName(s, string3);
                primaryKey.setName(resultSet.getString("PK_NAME"));
                arrayList.add(primaryKey);
            }
            resultSet.close();
        }
        this.primaryKeys.addAll(arrayList);
    }

    @Override
    protected void readColumns(String string) throws SQLException, JDBCException {
        this.updateListeners("Reading columns for " + this.database.toString() + " ...");
        if (this.database instanceof SQLiteDatabase) {
            for (Table table : this.tablesMap.values()) {
                Statement statement = this.database.getConnection().createStatement();
                ResultSet resultSet = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), table.getName(), null);
                if (resultSet == null) {
                    resultSet = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), table.getName(), null);
                }
                while (resultSet != null && resultSet.next()) {
                    Column column = this.readColumnInfo(string, resultSet);
                    if (column == null) continue;
                    this.columnsMap.put(column.getTable().getName() + "." + column.getName(), column);
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
            }
        } else {
            Statement statement = this.database.getConnection().createStatement();
            ResultSet resultSet = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(string), this.database.convertRequestedSchemaToSchema(string), null, null);
            while (resultSet.next()) {
                Column column = this.readColumnInfo(string, resultSet);
                if (column == null) continue;
                this.columnsMap.put(column.getTable().getName() + "." + column.getName(), column);
            }
            resultSet.close();
            statement.close();
        }
    }

    private Column readColumnInfo(String string, ResultSet resultSet) throws SQLException, JDBCException {
        Object object;
        String string2;
        Column column = new Column();
        String string3 = resultSet.getString("TABLE_NAME");
        String string4 = resultSet.getString("COLUMN_NAME");
        String string5 = resultSet.getString("TABLE_SCHEM");
        String string6 = resultSet.getString("TABLE_CAT");
        if (this.database.isSystemTable(string6, string5, string2 = string3.toUpperCase(Locale.ENGLISH)) || this.database.isLiquibaseTable(string2)) {
            return null;
        }
        Table table = (Table)this.tablesMap.get(string3);
        if (table == null) {
            object = (View)this.viewsMap.get(string3);
            if (object == null) {
                this.log.info("Could not find table or view " + string3 + " for column " + string4);
                return null;
            }
            column.setView((View)object);
            ((View)object).getColumns().add(column);
        } else {
            column.setTable(table);
            table.getColumns().add(column);
        }
        column.setName(string4);
        column.setDataType(resultSet.getInt("DATA_TYPE"));
        column.setColumnSize(resultSet.getInt("COLUMN_SIZE"));
        column.setDecimalDigits(resultSet.getInt("DECIMAL_POINTS"));
        object = resultSet.getObject("COLUMN_DEF");
        try {
            column.setDefaultValue(this.database.convertDatabaseValueToJavaObject(object, column.getDataType(), column.getColumnSize(), column.getDecimalDigits()));
        }
        catch (ParseException parseException) {
            throw new JDBCException(parseException);
        }
        int n = resultSet.getInt("NULLABLE");
        if (n == 0) {
            column.setNullable(false);
        } else if (n == 1) {
            column.setNullable(true);
        }
        column.setPrimaryKey(this.isPrimaryKey(column));
        column.setAutoIncrement(this.database.isColumnAutoIncrement(string, string3, string4));
        column.setTypeName(this.database.getColumnType(resultSet.getString("TYPE_NAME"), column.isAutoIncrement()));
        return column;
    }

    @Override
    protected void readIndexes(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading indexes for " + this.database.toString() + " ...");
        for (Object object : this.tablesMap.values()) {
            String string2;
            Object object2;
            Object object3;
            Object object4;
            block14: {
                object4 = null;
                object3 = null;
                object2 = new HashMap();
                object3 = this.database.getConnection().createStatement();
                string2 = "PRAGMA index_list(" + ((Table)object).getName() + ");";
                try {
                    object4 = object3.executeQuery(string2);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().equals("query does not return ResultSet")) break block14;
                    this.log.log(Level.WARNING, "error reading indexes", sQLException);
                }
            }
            while (object4 != null && object4.next()) {
                String string3 = object4.getString("name");
                boolean bl = object4.getBoolean("unique");
                string2 = "PRAGMA index_info(" + (String)string3 + ");";
                Statement statement = this.database.getConnection().createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                while (resultSet != null && resultSet.next()) {
                    DatabaseObject databaseObject;
                    int n = resultSet.getInt("seqno");
                    String string4 = resultSet.getString("name");
                    if (bl) {
                        databaseObject = (Column)this.columnsMap.get(((Table)object).getName() + "." + string4);
                        ((Column)databaseObject).setUnique(true);
                        continue;
                    }
                    if (object2.containsKey(string3)) {
                        databaseObject = (Index)object2.get(string3);
                    } else {
                        databaseObject = new Index();
                        ((Index)databaseObject).setTable((Table)object);
                        ((Index)databaseObject).setName(string3);
                        ((Index)databaseObject).setFilterCondition("");
                        object2.put(string3, databaseObject);
                    }
                    ((Index)databaseObject).getColumns().add(n, string4);
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement == null) continue;
                statement.close();
            }
            if (object4 != null) {
                object4.close();
            }
            if (object3 != null) {
                object3.close();
            }
            for (Map.Entry entry : object2.entrySet()) {
                this.indexes.add(entry.getValue());
            }
        }
        HashSet hashSet = new HashSet();
        for (Object object4 : this.indexes) {
            for (Object object2 : this.primaryKeys) {
                if (!((Index)object4).getTable().getName().equalsIgnoreCase(((PrimaryKey)object2).getTable().getName()) || !((Index)object4).getColumnNames().equals(((PrimaryKey)object2).getColumnNames())) continue;
                hashSet.add(object4);
            }
        }
        this.indexes.removeAll(hashSet);
    }

    @Override
    protected void readSequences(String string) throws JDBCException {
        this.updateListeners("Reading sequences for " + this.database.toString() + " ...");
        String string2 = this.database.convertRequestedSchemaToSchema(string);
        if (this.database.supportsSequences()) {
            List list = this.database.getJdbcTemplate().queryForList(this.database.createFindSequencesSQL(string), String.class, new ArrayList<SqlVisitor>());
            for (String string3 : list) {
                Sequence sequence = new Sequence();
                sequence.setName(string3.trim());
                sequence.setName(string2);
                this.sequences.add(sequence);
            }
        }
    }
}

