/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKey
implements DatabaseObject,
Comparable<PrimaryKey> {
    private String name;
    private List<String> columnNames = new ArrayList<String>();
    private Table table;
    private boolean certainName = true;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getColumnNames() {
        return StringUtils.join(this.columnNames, ", ");
    }

    public void addColumnName(int n, String string) {
        if (n >= this.columnNames.size()) {
            for (int i = this.columnNames.size() - 1; i < n; ++i) {
                this.columnNames.add(null);
            }
        }
        this.columnNames.set(n, string);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public int compareTo(PrimaryKey primaryKey) {
        int n = this.getTable().getName().compareTo(primaryKey.getTable().getName());
        if (n == 0) {
            n = this.getColumnNames().compareTo(primaryKey.getColumnNames());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PrimaryKey primaryKey = (PrimaryKey)object;
        return !(this.getColumnNames() == null ? primaryKey.getColumnNames() != null : !this.getColumnNames().equalsIgnoreCase(primaryKey.getColumnNames())) && !(this.getTable().getName() == null ? primaryKey.getTable().getName() != null : !this.getTable().getName().equalsIgnoreCase(primaryKey.getTable().getName()));
    }

    public int hashCode() {
        int n = this.getColumnNames() != null ? this.getColumnNames().toUpperCase().hashCode() : 0;
        n = 31 * n + (this.table.getName() != null ? this.table.getName().toUpperCase().hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.getName() + " on " + this.getTable().getName() + "(" + this.getColumnNames() + ")";
    }

    public List<String> getColumnNamesAsList() {
        return this.columnNames;
    }

    public boolean isCertainName() {
        return this.certainName;
    }

    public void setCertainName(boolean bl) {
        this.certainName = bl;
    }
}

