/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import liquibase.database.Database;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabaseSnapshot
extends SqlDatabaseSnapshot {
    public PostgresDatabaseSnapshot() {
    }

    public PostgresDatabaseSnapshot(Database database) throws JDBCException {
        super(database);
    }

    public PostgresDatabaseSnapshot(Database database, String string) throws JDBCException {
        super(database, string);
    }

    public PostgresDatabaseSnapshot(Database database, Set<DiffStatusListener> set) throws JDBCException {
        super(database, set);
    }

    public PostgresDatabaseSnapshot(Database database, Set<DiffStatusListener> set, String string) throws JDBCException {
        super(database, set, string);
    }

    @Override
    protected String convertFromDatabaseName(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\"", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readUniqueConstraints(String string) throws JDBCException, SQLException {
        this.updateListeners("Reading unique constraints for " + this.database.toString() + " ...");
        ArrayList<UniqueConstraint> arrayList = new ArrayList<UniqueConstraint>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.database.getConnection().prepareStatement("select pgc.conname, pgc.conrelid, pgc.conkey, pgcl.relname from pg_constraint pgc inner join pg_class pgcl on pgcl.oid = pgc.conrelid and pgcl.relkind ='r' where contype = 'u'");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("conname");
                int n = resultSet.getInt("conrelid");
                Array array = resultSet.getArray("conkey");
                String string3 = resultSet.getString("relname");
                UniqueConstraint uniqueConstraint = new UniqueConstraint();
                uniqueConstraint.setName(string2);
                uniqueConstraint.setTable((Table)this.tablesMap.get(string3));
                this.getColumnsForUniqueConstraint(n, array, uniqueConstraint);
                arrayList.add(uniqueConstraint);
            }
            this.uniqueConstraints.addAll(arrayList);
        }
        finally {
            resultSet.close();
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getColumnsForUniqueConstraint(int n, Array array, UniqueConstraint uniqueConstraint) throws SQLException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.database.getConnection().prepareStatement("select attname,attnum from pg_attribute where attrelid = ? and attnum in (" + array.toString().replace("{", "").replace("}", "") + ")");
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(new Integer(resultSet.getInt("attnum")), resultSet.getString("attname"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(array.toString().replace("{", "").replace("}", ""), ",");
            while (stringTokenizer.hasMoreTokens()) {
                Integer n2 = new Integer(stringTokenizer.nextToken());
                uniqueConstraint.getColumns().add((String)hashMap.get(n2));
            }
        }
        finally {
            resultSet.close();
            if (statement != null) {
                statement.close();
            }
        }
    }
}

