/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseSnapshot
extends SqlDatabaseSnapshot {
    public OracleDatabaseSnapshot() {
    }

    public OracleDatabaseSnapshot(Database database) throws JDBCException {
        super(database);
    }

    public OracleDatabaseSnapshot(Database database, String string) throws JDBCException {
        super(database, string);
    }

    public OracleDatabaseSnapshot(Database database, Set<DiffStatusListener> set) throws JDBCException {
        super(database, set);
    }

    public OracleDatabaseSnapshot(Database database, Set<DiffStatusListener> set, String string) throws JDBCException {
        super(database, set, string);
    }

    @Override
    protected void getColumnTypeAndDefValue(Column column, ResultSet resultSet, Database database) throws SQLException, JDBCException {
        super.getColumnTypeAndDefValue(column, resultSet, database);
        String string = resultSet.getString("TYPE_NAME");
        if ("VARCHAR2".equals(string)) {
            int n = resultSet.getInt("CHAR_OCTET_LENGTH");
            int n2 = resultSet.getInt("COLUMN_SIZE");
            if (n2 == n) {
                column.setLengthSemantics(Column.LengthSemantics.BYTE);
            } else {
                column.setLengthSemantics(Column.LengthSemantics.CHAR);
            }
        }
    }
}

