/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabaseSnapshot
extends SqlDatabaseSnapshot {
    private static Map<String, Map<String, List<String>>> schemaCache = new HashMap<String, Map<String, List<String>>>();

    public MySqlDatabaseSnapshot() {
    }

    public MySqlDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public MySqlDatabaseSnapshot(Database database, String string) throws JDBCException {
        this(database, null, string);
    }

    public MySqlDatabaseSnapshot(Database database, Set<DiffStatusListener> set) throws JDBCException {
        this(database, set, database.getDefaultSchemaName());
    }

    public MySqlDatabaseSnapshot(Database database, Set<DiffStatusListener> set, String string) throws JDBCException {
        super(database, set, string);
    }

    @Override
    protected void getColumnTypeAndDefValue(Column column, ResultSet resultSet, Database database) throws SQLException, JDBCException {
        Object object;
        String string = resultSet.getString("TYPE_NAME");
        String string2 = resultSet.getString("COLUMN_NAME");
        String string3 = resultSet.getString("TABLE_NAME");
        String string4 = resultSet.getString("TABLE_CAT");
        Map<Object, Object> map = new HashMap();
        if (!schemaCache.containsKey(string3)) {
            object = database.getConnection().createStatement();
            ResultSet resultSet2 = object.executeQuery("DESC " + database.escapeTableName(string4, string3));
            while (resultSet2.next()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(resultSet2.getString("Type"));
                arrayList.add(resultSet2.getString("Default"));
                map.put(resultSet2.getString("Field"), arrayList);
            }
            resultSet2.close();
            schemaCache.put(string3, map);
        }
        map = schemaCache.get(string3);
        if (string.toLowerCase().startsWith("enum") || string.toLowerCase().startsWith("set")) {
            column.setTypeName((String)((List)map.get(string2)).get(0));
            try {
                object = (String)database.convertDatabaseValueToJavaObject(((List)map.get(string2)).get(1), column.getDataType(), column.getColumnSize(), column.getDecimalDigits());
                if ("".equals(object)) {
                    column.setDefaultValue(null);
                }
                column.setDefaultValue(object);
            }
            catch (ParseException parseException) {
                throw new JDBCException(parseException);
            }
        } else if (string.toLowerCase().equals("text") || string.toLowerCase().equals("blob")) {
            column.setTypeName(string);
            column.setDefaultValue(null);
        } else if (string.toLowerCase().equals("timestamp") && !"CURRENT_TIMESTAMP".equals(((List)map.get(string2)).get(1))) {
            column.setTypeName(string);
            column.setDefaultValue(((List)map.get(string2)).get(1));
        } else {
            super.getColumnTypeAndDefValue(column, resultSet, database);
        }
    }

    @Override
    protected String convertPrimaryKeyName(String string) throws SQLException {
        if (string.equals("PRIMARY")) {
            return null;
        }
        return string;
    }
}

