/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
implements DatabaseObject,
Comparable<Index> {
    private String name;
    private Table table;
    private Boolean unique;
    private List<String> columns = new ArrayList<String>();
    private String filterCondition;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumnNames() {
        return StringUtils.join(this.columns, ", ");
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String string) {
        this.filterCondition = string;
    }

    public void setUnique(Boolean bl) {
        this.unique = bl;
    }

    public Boolean isUnique() {
        return this.unique;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Index index = (Index)object;
        boolean bl = true;
        for (String string : index.getColumns()) {
            if (this.columns.contains(string)) continue;
            bl = false;
        }
        if (this.unique != null || index.isUnique() != null) {
            if (this.unique == null && index.isUnique() != null) {
                bl = false;
            } else if (this.unique != null && index.isUnique() == null) {
                bl = false;
            } else if (!this.unique.equals(index.isUnique())) {
                bl = false;
            }
        }
        return bl || this.table.getName().equalsIgnoreCase(index.table.getName());
    }

    public int hashCode() {
        int n = this.table.getName().toUpperCase().hashCode();
        n = 31 * n + ((Object)this.columns).hashCode();
        n = 31 * n + (this.unique == null || this.unique != false ? 1 : 0);
        return n;
    }

    @Override
    public int compareTo(Index index) {
        int n = this.table.getName().compareTo(index.table.getName());
        if (n == 0) {
            n = this.getName().compareTo(index.getName());
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (!this.unique.booleanValue()) {
            stringBuffer.append(" unique ");
        }
        stringBuffer.append(" on ").append(this.table.getName()).append("(");
        for (String string : this.columns) {
            stringBuffer.append(string).append(", ");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

