/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

public class HibernateGenericDialect
extends Dialect {
    private Dialect realDialect;

    public HibernateGenericDialect(Configuration configuration) throws Exception {
        String string = configuration.getProperty("hibernate.dialect");
        if (string == null) {
            string = configuration.getProperty("dialect");
        }
        this.realDialect = (Dialect)Class.forName(string).newInstance();
    }

    public String getTypeName(int n, int n2, int n3, int n4) throws HibernateException {
        if (n == -5) {
            return "bigint";
        }
        if (n == 16) {
            return "boolean";
        }
        if (n == 2004) {
            return "blob";
        }
        if (n == 2005) {
            return "clob";
        }
        if (n == 91) {
            return "date";
        }
        if (n == 6) {
            return "float";
        }
        if (n == 92) {
            return "time";
        }
        if (n == 93) {
            return "datetime";
        }
        if (n == 12) {
            return "varchar";
        }
        return this.realDialect.getTypeName(n, n2, n3, n4);
    }
}

