/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.database.Database;
import liquibase.database.HibernateDatabase;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.HibernateGenericDialect;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.UniqueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDatabaseSnapshot
implements DatabaseSnapshot {
    private HibernateDatabase database;
    private Set<Table> tables = new HashSet<Table>();
    private Set<Column> columns = new HashSet<Column>();
    private Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    private Set<Index> indexes = new HashSet<Index>();
    private Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    private Set<Sequence> sequences = new HashSet<Sequence>();
    private Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    private Map<String, Table> tablesMap = new HashMap<String, Table>();
    private Map<String, Column> columnsMap = new HashMap<String, Column>();
    private static final Logger log = LogFactory.getLogger();

    public HibernateDatabaseSnapshot(HibernateDatabase hibernateDatabase) throws JDBCException {
        try {
            ArrayList<String> arrayList;
            Object object;
            Iterator iterator;
            Object object2;
            org.hibernate.mapping.Table table;
            Configuration configuration = hibernateDatabase.createConfiguration();
            configuration.configure(hibernateDatabase.getConfigFile());
            this.database = hibernateDatabase;
            HibernateGenericDialect hibernateGenericDialect = new HibernateGenericDialect(configuration);
            configuration.buildMappings();
            Mapping mapping = configuration.buildMapping();
            Iterator iterator2 = configuration.getTableMappings();
            while (iterator2.hasNext()) {
                DatabaseObject databaseObject;
                org.hibernate.mapping.PrimaryKey primaryKey;
                table = (org.hibernate.mapping.Table)iterator2.next();
                if (!table.isPhysicalTable()) continue;
                object2 = new Table(table.getName());
                System.out.println("seen table " + ((Table)object2).getName());
                this.tablesMap.put(((Table)object2).getName(), (Table)object2);
                iterator = table.getColumnIterator();
                while (iterator.hasNext()) {
                    object = (org.hibernate.mapping.Column)iterator.next();
                    arrayList = new Column();
                    ((Column)((Object)arrayList)).setName(object.getName());
                    ((Column)((Object)arrayList)).setDataType(object.getSqlTypeCode(mapping));
                    if (((Column)((Object)arrayList)).isNumeric()) {
                        ((Column)((Object)arrayList)).setColumnSize(object.getPrecision());
                    } else {
                        ((Column)((Object)arrayList)).setColumnSize(object.getLength());
                    }
                    ((Column)((Object)arrayList)).setDecimalDigits(object.getScale());
                    ((Column)((Object)arrayList)).setDefaultValue(object.getDefaultValue());
                    ((Column)((Object)arrayList)).setNullable(object.isNullable());
                    ((Column)((Object)arrayList)).setPrimaryKey(this.isPrimaryKey(table, (org.hibernate.mapping.Column)object));
                    ((Column)((Object)arrayList)).setTable((Table)object2);
                    ((Column)((Object)arrayList)).setTypeName(object.getSqlType((Dialect)hibernateGenericDialect, mapping).replaceFirst("\\(.*\\)", ""));
                    ((Column)((Object)arrayList)).setUnique(object.isUnique());
                    ((Column)((Object)arrayList)).setCertainDataType(false);
                    this.columnsMap.put(((Table)object2).getName() + "." + ((Column)((Object)arrayList)).getName(), (Column)((Object)arrayList));
                    ((Table)object2).getColumns().add((Column)((Object)arrayList));
                }
                object = table.getIndexIterator();
                while (object.hasNext()) {
                    arrayList = (org.hibernate.mapping.Index)object.next();
                    primaryKey = new Index();
                    primaryKey.setTable((Table)object2);
                    primaryKey.setName(arrayList.getName());
                    iterator = arrayList.getColumnIterator();
                    while (iterator.hasNext()) {
                        databaseObject = (org.hibernate.mapping.Column)iterator.next();
                        primaryKey.getColumns().add(databaseObject.getName());
                    }
                    this.indexes.add((Index)primaryKey);
                }
                arrayList = table.getUniqueKeyIterator();
                while (arrayList.hasNext()) {
                    primaryKey = (UniqueKey)arrayList.next();
                    databaseObject = new Index();
                    databaseObject.setTable((Table)object2);
                    databaseObject.setName(primaryKey.getName());
                    iterator = primaryKey.getColumnIterator();
                    while (iterator.hasNext()) {
                        org.hibernate.mapping.Column column = (org.hibernate.mapping.Column)iterator.next();
                        databaseObject.getColumns().add(column.getName());
                    }
                    this.indexes.add((Index)databaseObject);
                }
                primaryKey = table.getPrimaryKey();
                if (primaryKey == null) continue;
                databaseObject = new PrimaryKey();
                ((PrimaryKey)databaseObject).setName(primaryKey.getName());
                ((PrimaryKey)databaseObject).setTable((Table)object2);
                for (Object e : primaryKey.getColumns()) {
                    ((PrimaryKey)databaseObject).getColumnNamesAsList().add(((org.hibernate.mapping.Column)e).getName());
                }
                this.primaryKeys.add((PrimaryKey)databaseObject);
            }
            this.tables = new HashSet<Table>(this.tablesMap.values());
            this.columns = new HashSet<Column>(this.columnsMap.values());
            iterator2 = configuration.getTableMappings();
            while (iterator2.hasNext()) {
                table = (org.hibernate.mapping.Table)iterator2.next();
                if (!table.isPhysicalTable()) continue;
                object2 = table.getForeignKeyIterator();
                while (object2.hasNext()) {
                    iterator = (org.hibernate.mapping.ForeignKey)object2.next();
                    if (iterator.getTable() == null || iterator.getReferencedTable() == null || !iterator.isPhysicalConstraint()) continue;
                    object = new ForeignKey();
                    ((ForeignKey)object).setName(iterator.getName());
                    ((ForeignKey)object).setForeignKeyTable(this.getTable(iterator.getTable().getName()));
                    arrayList = new ArrayList<String>();
                    for (DatabaseObject databaseObject : iterator.getColumns()) {
                        arrayList.add(((org.hibernate.mapping.Column)databaseObject).getName());
                    }
                    ((ForeignKey)object).setForeignKeyColumns(StringUtils.join(arrayList, ", "));
                    ((ForeignKey)object).setPrimaryKeyTable(this.getTable(iterator.getReferencedTable().getName()));
                    arrayList = new ArrayList();
                    for (DatabaseObject databaseObject : iterator.getReferencedColumns()) {
                        arrayList.add(((org.hibernate.mapping.Column)databaseObject).getName());
                    }
                    if (arrayList.size() == 0) {
                        for (DatabaseObject databaseObject : iterator.getReferencedTable().getPrimaryKey().getColumns()) {
                            arrayList.add(((org.hibernate.mapping.Column)databaseObject).getName());
                        }
                    }
                    ((ForeignKey)object).setPrimaryKeyColumns(StringUtils.join(arrayList, ", "));
                    this.foreignKeys.add((ForeignKey)object);
                }
            }
        }
        catch (Exception exception) {
            throw new JDBCException(exception);
        }
    }

    private boolean isPrimaryKey(org.hibernate.mapping.Table table, org.hibernate.mapping.Column column) {
        org.hibernate.mapping.PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            return false;
        }
        Iterator iterator = primaryKey.getColumnIterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    @Override
    public Set<View> getViews() {
        return new HashSet<View>();
    }

    @Override
    public Column getColumn(Column column) {
        if (column.getTable() == null) {
            return this.getColumn(column.getView().getName(), column.getName());
        }
        return this.getColumn(column.getTable().getName(), column.getName());
    }

    @Override
    public Column getColumn(String string, String string2) {
        String string3 = string + "." + string2;
        Column column = this.columnsMap.get(string3);
        if (column == null) {
            for (String string4 : this.columnsMap.keySet()) {
                if (!string4.equalsIgnoreCase(string3)) continue;
                return this.columnsMap.get(string4);
            }
        }
        return column;
    }

    @Override
    public Set<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public Set<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public Table getTable(String string) {
        for (Table table : this.getTables()) {
            if (!table.getName().equalsIgnoreCase(string)) continue;
            return table;
        }
        return null;
    }

    @Override
    public ForeignKey getForeignKey(String string) {
        for (ForeignKey foreignKey : this.getForeignKeys()) {
            if (!foreignKey.getName().equalsIgnoreCase(string)) continue;
            return foreignKey;
        }
        return null;
    }

    @Override
    public Sequence getSequence(String string) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equalsIgnoreCase(string)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public Index getIndex(String string) {
        for (Index index : this.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(string)) continue;
            return index;
        }
        return null;
    }

    @Override
    public View getView(String string) {
        for (View view : this.getViews()) {
            if (!view.getName().equalsIgnoreCase(string)) continue;
            return view;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKey(String string) {
        for (PrimaryKey primaryKey : this.getPrimaryKeys()) {
            if (!primaryKey.getName().equalsIgnoreCase(string)) continue;
            return primaryKey;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKeyForTable(String string) {
        for (PrimaryKey primaryKey : this.getPrimaryKeys()) {
            if (!primaryKey.getTable().getName().equalsIgnoreCase(string)) continue;
            return primaryKey;
        }
        return null;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() {
        return false;
    }

    @Override
    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public UniqueConstraint getUniqueConstraint(String string) {
        for (UniqueConstraint uniqueConstraint : this.getUniqueConstraints()) {
            if (!uniqueConstraint.getName().equalsIgnoreCase(string)) continue;
            return uniqueConstraint;
        }
        return null;
    }
}

