/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.List;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKey
implements DatabaseObject,
Comparable<ForeignKey> {
    private Table primaryKeyTable;
    private String primaryKeyColumns;
    private Table foreignKeyTable;
    private String foreignKeyColumns;
    private String name;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private Integer updateRule;
    private Integer deleteRule;

    public Table getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    public void setPrimaryKeyTable(Table table) {
        this.primaryKeyTable = table;
    }

    public String getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void addPrimaryKeyColumn(String string) {
        this.primaryKeyColumns = this.primaryKeyColumns == null || this.primaryKeyColumns.length() == 0 ? string : this.primaryKeyColumns + ", " + string;
    }

    public void setPrimaryKeyColumns(String string) {
        this.primaryKeyColumns = string;
    }

    public Table getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public void setForeignKeyTable(Table table) {
        this.foreignKeyTable = table;
    }

    public String getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public void addForeignKeyColumn(String string) {
        this.foreignKeyColumns = this.foreignKeyColumns == null || this.foreignKeyColumns.length() == 0 ? string : this.foreignKeyColumns + ", " + string;
    }

    public void setForeignKeyColumns(String string) {
        this.foreignKeyColumns = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getName() + "(" + this.getForeignKeyTable() + "." + this.getForeignKeyColumns() + " ->" + this.getPrimaryKeyTable() + "." + this.getPrimaryKeyColumns() + ")";
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(boolean bl) {
        this.deferrable = bl;
    }

    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(boolean bl) {
        this.initiallyDeferred = bl;
    }

    public void setUpdateRule(Integer n) {
        this.updateRule = n;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public void setDeleteRule(Integer n) {
        this.deleteRule = n;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ForeignKey foreignKey = (ForeignKey)object;
        if (this.getForeignKeyColumns() == null) {
            return this.getName().equalsIgnoreCase(foreignKey.getName());
        }
        return this.getForeignKeyColumns().equalsIgnoreCase(foreignKey.getForeignKeyColumns()) && this.foreignKeyTable.equals(foreignKey.foreignKeyTable) && this.getPrimaryKeyColumns().equalsIgnoreCase(foreignKey.getPrimaryKeyColumns()) && this.primaryKeyTable.equals(foreignKey.primaryKeyTable);
    }

    public int hashCode() {
        int n = 0;
        if (this.primaryKeyTable != null) {
            n = this.primaryKeyTable.hashCode();
        }
        if (this.primaryKeyColumns != null) {
            n = 31 * n + this.primaryKeyColumns.toUpperCase().hashCode();
        }
        if (this.foreignKeyTable != null) {
            n = 31 * n + this.foreignKeyTable.hashCode();
        }
        if (this.foreignKeyColumns != null) {
            n = 31 * n + this.foreignKeyColumns.toUpperCase().hashCode();
        }
        if (this.updateRule != null) {
            n = 31 * n + this.updateRule.hashCode();
        }
        if (this.deleteRule != null) {
            n = 31 * n + this.deleteRule.hashCode();
        }
        return n;
    }

    @Override
    public int compareTo(ForeignKey foreignKey) {
        int n = 0;
        if (this.getForeignKeyTable() != null && foreignKey.getForeignKeyTable() != null) {
            n = this.getForeignKeyTable().compareTo(foreignKey.getForeignKeyTable());
        }
        if (n == 0 && this.getForeignKeyColumns() != null && foreignKey.getForeignKeyColumns() != null) {
            n = this.getForeignKeyColumns().compareToIgnoreCase(foreignKey.getForeignKeyColumns());
        }
        if (n == 0 && this.getName() != null && foreignKey.getName() != null) {
            n = this.getName().compareToIgnoreCase(foreignKey.getName());
        }
        if (n == 0 && this.getPrimaryKeyTable() != null && foreignKey.getPrimaryKeyTable() != null) {
            n = this.getPrimaryKeyTable().compareTo(foreignKey.getPrimaryKeyTable());
        }
        if (n == 0 && this.getPrimaryKeyColumns() != null && foreignKey.getPrimaryKeyColumns() != null) {
            n = this.getPrimaryKeyColumns().compareToIgnoreCase(foreignKey.getPrimaryKeyColumns());
        }
        if (n == 0 && this.updateRule != null && foreignKey.getUpdateRule() != null) {
            n = this.updateRule.compareTo(foreignKey.getUpdateRule());
        }
        if (n == 0 && this.deleteRule != null && foreignKey.getDeleteRule() != null) {
            n = this.deleteRule.compareTo(foreignKey.getDeleteRule());
        }
        return n;
    }

    private String toDisplayString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string : list) {
            stringBuilder.append(string);
            if (++n >= list.size()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

