/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.Arrays;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.log.LogFactory;
import liquibase.util.SqlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
implements DatabaseObject,
Comparable<Column> {
    private Table table;
    private View view;
    private String name;
    private int dataType;
    private int columnSize;
    private int decimalDigits;
    private LengthSemantics lengthSemantics;
    private Boolean nullable;
    private String typeName;
    private Object defaultValue;
    private boolean autoIncrement = false;
    private boolean primaryKey = false;
    private boolean unique = false;
    private boolean certainDataType = true;
    private String remarks;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int n) {
        this.columnSize = n;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int n) {
        this.decimalDigits = n;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean bl) {
        this.nullable = bl;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public String toString() {
        String string = this.table == null ? this.view.getName() : this.table.getName();
        return string + "." + this.getName();
    }

    @Override
    public int compareTo(Column column) {
        try {
            int n = 0;
            if (this.getTable() != null && column.getTable() == null) {
                return 1;
            }
            if (this.getTable() == null && column.getTable() != null) {
                return -1;
            }
            n = this.getTable() == null && column.getTable() == null ? this.getView().compareTo(column.getView()) : this.getTable().compareTo(column.getTable());
            if (n == 0) {
                n = this.getName().compareTo(column.getName());
            }
            return n;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Column column = (Column)object;
            return this.name.equalsIgnoreCase(column.name) && !(this.table == null ? column.table != null : !this.table.equals(column.table)) && !(this.view == null ? column.view != null : !this.view.equals(column.view));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        try {
            int n = this.table != null ? this.table.hashCode() : 0;
            n = 31 * n + (this.view != null ? this.view.hashCode() : 0);
            n = 31 * n + this.name.toUpperCase().hashCode();
            return n;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getDataTypeString(Database database) {
        String string;
        List<Integer> list = Arrays.asList(2003, -5, -2, -7, 2004, 16, 2005, 70, 91, 2001, 4, 2000, -4, 0, 1111, 2006, 5, 2002, 92, 93, -6, -1);
        List<Integer> list2 = Arrays.asList(1, 12, -3, 8, 6);
        List<Integer> list3 = Arrays.asList(3, 2, 7);
        String string2 = this.getTypeName();
        if (database instanceof PostgresDatabase && "bpchar".equals(string2)) {
            string2 = "char";
        }
        if ((database instanceof HsqlDatabase || database instanceof DerbyDatabase) && (this.getDataType() == 6 || this.getDataType() == 8)) {
            return "float";
        }
        if (list.contains(this.getDataType())) {
            string = string2;
        } else if (list2.contains(this.getDataType())) {
            if (database instanceof PostgresDatabase && string2.equals("text")) {
                return string2;
            }
            if (database instanceof MSSQLDatabase && string2.equals("uniqueidentifier")) {
                return string2;
            }
            if (database instanceof MySQLDatabase && (string2.startsWith("enum(") || string2.startsWith("set("))) {
                return string2;
            }
            if (database instanceof OracleDatabase && string2.equals("VARCHAR2")) {
                return string2 + "(" + this.getColumnSize() + " " + (Object)((Object)this.lengthSemantics) + ")";
            }
            string = string2 + "(" + this.getColumnSize() + ")";
        } else if (list3.contains(this.getDataType())) {
            string = database instanceof PostgresDatabase && this.getColumnSize() == 131089 ? "DECIMAL" : (database instanceof MSSQLDatabase && string2.equalsIgnoreCase("money") ? string2.toUpperCase() : string2 + "(" + this.getColumnSize() + "," + this.getDecimalDigits() + ")");
        } else {
            LogFactory.getLogger().warning("Unknown Data Type: " + this.getDataType() + " (" + this.getTypeName() + ").  Assuming it does not take parameters");
            string = this.getTypeName();
        }
        return string;
    }

    public boolean isNumeric() {
        return SqlUtil.isNumeric(this.getDataType());
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean bl) {
        this.autoIncrement = bl;
    }

    public boolean isDataTypeDifferent(Column column) {
        if (!this.isCertainDataType() || !column.isCertainDataType()) {
            return false;
        }
        return this.getDataType() != column.getDataType() || this.getColumnSize() != column.getColumnSize() || this.getDecimalDigits() != column.getDecimalDigits() || this.getLengthSemantics() != column.getLengthSemantics();
    }

    public boolean isNullabilityDifferent(Column column) {
        if (this.isNullable() == null && column.isNullable() == null) {
            return false;
        }
        if (this.isNullable() == null && column.isNullable() != null) {
            return true;
        }
        if (this.isNullable() != null && column.isNullable() == null) {
            return true;
        }
        return !this.isNullable().equals(column.isNullable());
    }

    public boolean isDifferent(Column column) {
        return this.isDataTypeDifferent(column) || this.isNullabilityDifferent(column);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    public boolean isCertainDataType() {
        return this.certainDataType;
    }

    public void setCertainDataType(boolean bl) {
        this.certainDataType = bl;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public LengthSemantics getLengthSemantics() {
        return this.lengthSemantics;
    }

    public void setLengthSemantics(LengthSemantics lengthSemantics) {
        this.lengthSemantics = lengthSemantics;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LengthSemantics {
        CHAR,
        BYTE;

    }
}

