/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql.visitor;

import java.util.HashMap;
import java.util.Map;
import liquibase.database.sql.visitor.AppendSqlVisitor;
import liquibase.database.sql.visitor.PrependSqlVisitor;
import liquibase.database.sql.visitor.RegExpReplaceSqlVisitor;
import liquibase.database.sql.visitor.ReplaceSqlVisitor;
import liquibase.database.sql.visitor.SqlVisitor;

public class SqlVisitorFactory {
    private final Map<String, Class> tagToClassMap = new HashMap<String, Class>();
    private static final SqlVisitorFactory instance = new SqlVisitorFactory();

    private SqlVisitorFactory() {
        Class[] classArray = new Class[]{PrependSqlVisitor.class, AppendSqlVisitor.class, RegExpReplaceSqlVisitor.class, ReplaceSqlVisitor.class};
        try {
            for (Class clazz : classArray) {
                SqlVisitor sqlVisitor = (SqlVisitor)clazz.newInstance();
                this.tagToClassMap.put(sqlVisitor.getTagName(), clazz);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SqlVisitorFactory getInstance() {
        return instance;
    }

    public SqlVisitor create(String string) {
        Class clazz = this.tagToClassMap.get(string);
        if (clazz == null) {
            throw new RuntimeException("Unknown tag: " + string);
        }
        try {
            return (SqlVisitor)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

