/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private Map<String, Object> newColumnValues = new HashMap<String, Object>();
    private String whereClause;
    private List<Object> whereParameters = new ArrayList<Object>();

    public UpdateStatement(String string, String string2) {
        this.schemaName = string;
        this.tableName = string2;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UpdateStatement addNewColumnValue(String string, Object object) {
        this.newColumnValues.put(string, object);
        return this;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public UpdateStatement setWhereClause(String string) {
        this.whereClause = string;
        return this;
    }

    public void addWhereParameter(Object object) {
        this.whereParameters.add(object);
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    public Map<String, Object> getNewColumnValues() {
        return this.newColumnValues;
    }

    @Override
    public String getSqlStatement(Database database) {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " SET");
        for (String object : this.newColumnValues.keySet()) {
            stringBuffer.append(" ").append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), object)).append(" = ");
            stringBuffer.append(this.convertToString(this.newColumnValues.get(object), database));
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
        if (this.whereClause != null) {
            Object object = "WHERE " + this.whereClause;
            for (Object object2 : this.whereParameters) {
                object = ((String)object).replaceFirst("\\?", this.convertToString(object2, database));
            }
            stringBuffer.append(" ").append((String)object);
        }
        return stringBuffer.toString();
    }

    private String convertToString(Object object, Database database) {
        String string = object == null || object.toString().equalsIgnoreCase("NULL") ? "NULL" : (object instanceof String && database.shouldQuoteValue((String)object) ? "'" + database.escapeStringForDatabase(object.toString()) + "'" : (object instanceof Date ? database.getDateLiteral((Date)object) : (object instanceof Boolean ? (((Boolean)object).booleanValue() ? database.getTrueBooleanValue() : database.getFalseBooleanValue()) : object.toString())));
        return string;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }
}

