/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.MySQLDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class TagDatabaseStatement
implements SqlStatement {
    private String tag;

    public TagDatabaseStatement(String string) {
        this.tag = string;
    }

    public String getTag() {
        return this.tag;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        UpdateStatement updateStatement = new UpdateStatement(database.getDefaultSchemaName(), database.getDatabaseChangeLogTableName());
        updateStatement.addNewColumnValue("TAG", this.tag);
        if (database instanceof MySQLDatabase) {
            try {
                long l = Long.parseLong(database.getDatabaseProductVersion().substring(0, 1));
                if (l < 5L) {
                    return new RawSqlStatement("UPDATE DATABASECHANGELOG C LEFT JOIN (SELECT MAX(DATEEXECUTED) as MAXDATE FROM (SELECT DATEEXECUTED FROM `DATABASECHANGELOG`) AS X) D ON C.DATEEXECUTED = D.MAXDATE SET C.TAG = '" + this.tag + "' WHERE D.MAXDATE IS NOT NULL").getSqlStatement(database);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            updateStatement.setWhereClause("DATEEXECUTED = (SELECT MAX(DATEEXECUTED) FROM (SELECT DATEEXECUTED FROM " + database.escapeTableName(database.getDefaultSchemaName(), database.getDatabaseChangeLogTableName()) + ") AS X)");
        } else {
            updateStatement.setWhereClause("DATEEXECUTED = (SELECT MAX(DATEEXECUTED) FROM " + database.escapeTableName(database.getDefaultSchemaName(), database.getDatabaseChangeLogTableName()) + ")");
        }
        return updateStatement.getSqlStatement(database);
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

