/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.sql.CallableSqlStatement;
import liquibase.database.sql.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureStatement
implements SqlStatement,
CallableSqlStatement {
    private String procedureName;
    private List<String> parameters = new ArrayList<String>();
    private List<Integer> types = new ArrayList<Integer>();

    public StoredProcedureStatement(String string) {
        this.procedureName = string;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public List<String> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(String string, int n) {
        this.parameters.add(string);
        this.types.add(n);
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    @Override
    public String getSqlStatement(Database database) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("exec (").append(this.procedureName);
        for (String string : this.getParameters()) {
            stringBuffer.append(" ").append(string).append(",");
        }
        return stringBuffer.toString().replaceFirst(",$", ")");
    }

    @Override
    public CallableStatement createCallableStatement(Database database) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("{call " + this.getProcedureName());
        if (this.parameters.size() > 0) {
            stringBuffer.append("(");
            for (String string : this.parameters) {
                stringBuffer.append("?,");
            }
            stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
            stringBuffer.append(")");
        }
        stringBuffer.append("}");
        CallableStatement callableStatement = database.getConnection().prepareCall(stringBuffer.toString());
        for (int i = 0; i < this.parameters.size(); ++i) {
            String string = this.parameters.get(i);
            int n = database.getDatabaseType(this.types.get(i));
            if (string == null) {
                callableStatement.setNull(i + 1, n);
                continue;
            }
            callableStatement.setObject(i + 1, (Object)string, n);
        }
        return callableStatement;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }
}

