/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class SetNullableStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;
    private boolean nullable;

    public SetNullableStatement(String string, String string2, String string3, String string4, boolean bl) {
        this.schemaName = string;
        this.tableName = string2;
        this.columnName = string3;
        this.columnDataType = string4;
        this.nullable = bl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        String string = this.isNullable() ? " NULL" : " NOT NULL";
        if (database instanceof OracleDatabase || database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + string;
        }
        if (database instanceof MSSQLDatabase) {
            if (this.getColumnDataType() == null) {
                throw new StatementNotSupportedOnDatabaseException("Database requires columnDataType parameter", this, database);
            }
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " " + this.getColumnDataType() + string;
        }
        if (database instanceof MySQLDatabase) {
            if (this.getColumnDataType() == null) {
                throw new StatementNotSupportedOnDatabaseException("Database requires columnDataType parameter", this, database);
            }
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " " + this.getColumnDataType() + string;
        }
        if (database instanceof DerbyDatabase || database instanceof CacheDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + string;
        }
        if (database instanceof HsqlDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " " + this.getColumnDataType() + string;
        }
        if (database instanceof FirebirdDatabase) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MaxDBDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + (this.isNullable() ? " DEFAULT NULL" : " NOT NULL");
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + (this.isNullable() ? " DROP NOT NULL" : " SET NOT NULL");
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof FirebirdDatabase) && !(database instanceof SQLiteDatabase);
    }
}

