/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class RenameViewStatement
implements SqlStatement {
    private String schemaName;
    private String oldViewName;
    private String newViewName;

    public RenameViewStatement(String string, String string2, String string3) {
        this.schemaName = string;
        this.oldViewName = string2;
        this.newViewName = string3;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getOldViewName() {
        return this.oldViewName;
    }

    public String getNewViewName() {
        return this.newViewName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MSSQLDatabase) {
            return "exec sp_rename '" + database.escapeViewName(this.getSchemaName(), this.getOldViewName()) + "', " + database.escapeViewName(null, this.getNewViewName());
        }
        if (database instanceof MySQLDatabase) {
            return "RENAME TABLE " + database.escapeViewName(this.getSchemaName(), this.getOldViewName()) + " TO " + database.escapeViewName(this.getSchemaName(), this.getNewViewName());
        }
        if (database instanceof PostgresDatabase) {
            return "ALTER TABLE " + database.escapeViewName(this.getSchemaName(), this.getOldViewName()) + " RENAME TO " + database.escapeViewName(null, this.getNewViewName());
        }
        if (database instanceof MaxDBDatabase) {
            return "RENAME VIEW " + database.escapeViewName(this.getSchemaName(), this.getOldViewName()) + " TO " + database.escapeViewName(null, this.getNewViewName());
        }
        if (this.getSchemaName() != null && database instanceof OracleDatabase) {
            throw new StatementNotSupportedOnDatabaseException("Cannot specify schema when renaming in oracle", this, database);
        }
        if (database instanceof SybaseASADatabase) {
            throw new StatementNotSupportedOnDatabaseException("Sybase ASA does not support renaming of view. Please drop old view and create a new one manually.", this, database);
        }
        return "RENAME " + database.escapeViewName(this.getSchemaName(), this.getOldViewName()) + " TO " + database.escapeViewName(null, this.getNewViewName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof DerbyDatabase) && !(database instanceof HsqlDatabase) && !(database instanceof DB2Database) && !(database instanceof CacheDatabase) && !(database instanceof FirebirdDatabase);
    }
}

