/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class RenameTableStatement
implements SqlStatement {
    private String schemaName;
    private String oldTableName;
    private String newTableName;

    public RenameTableStatement(String string, String string2, String string3) {
        this.schemaName = string;
        this.oldTableName = string2;
        this.newTableName = string3;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getOldTableName() {
        return this.oldTableName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MSSQLDatabase) {
            return "exec sp_rename '" + database.escapeTableName(this.getSchemaName(), this.oldTableName) + "', " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof MySQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " RENAME " + database.escapeTableName(this.getSchemaName(), this.getNewTableName());
        }
        if (database instanceof PostgresDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " RENAME TO " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " RENAME " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof DerbyDatabase || database instanceof MaxDBDatabase) {
            return "RENAME TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " TO " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof HsqlDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " RENAME TO " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof OracleDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " RENAME TO " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof DB2Database) {
            return "RENAME " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " TO " + database.escapeTableName(null, this.newTableName);
        }
        if (database instanceof SQLiteDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.oldTableName) + " RENAME TO " + database.escapeTableName(null, this.newTableName);
        }
        return "RENAME " + database.escapeTableName(this.getSchemaName(), this.getOldTableName()) + " TO " + database.escapeTableName(this.getSchemaName(), this.getNewTableName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof CacheDatabase) && !(database instanceof FirebirdDatabase);
    }
}

