/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class RenameColumnStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String oldColumnName;
    private String newColumnName;
    private String columnDataType;

    public RenameColumnStatement(String string, String string2, String string3, String string4, String string5) {
        this.schemaName = string;
        this.tableName = string2;
        this.oldColumnName = string3;
        this.newColumnName = string4;
        this.columnDataType = string5;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getOldColumnName() {
        return this.oldColumnName;
    }

    public void setOldColumnName(String string) {
        this.oldColumnName = string;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String string) {
        this.newColumnName = string;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String string) {
        this.columnDataType = string;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MSSQLDatabase) {
            return "exec sp_rename '" + database.escapeTableName(this.getSchemaName(), this.getTableName()) + "." + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + "', '" + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName()) + "'";
        }
        if (database instanceof MySQLDatabase) {
            if (this.getColumnDataType() == null) {
                throw new StatementNotSupportedOnDatabaseException("columnDataType is required to rename columns", this, database);
            }
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " CHANGE " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName()) + " " + this.getColumnDataType();
        }
        if (database instanceof HsqlDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " RENAME TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
        }
        if (database instanceof FirebirdDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
        }
        if (database instanceof MaxDBDatabase || database instanceof DerbyDatabase) {
            return "RENAME COLUMN " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + "." + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " RENAME COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof DB2Database) && !(database instanceof CacheDatabase) && !(database instanceof SQLiteDatabase);
    }
}

