/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class InsertStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private Map<String, Object> newColumnValues = new HashMap<String, Object>();

    public InsertStatement(String string, String string2) {
        this.schemaName = string;
        this.tableName = string2;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public InsertStatement addColumnValue(String string, Object object) {
        this.newColumnValues.put(string, object);
        return this;
    }

    public Object getColumnValue(String string) {
        return this.newColumnValues.get(string);
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (this.getSchemaName() != null && !database.supportsSchemas()) {
            throw new StatementNotSupportedOnDatabaseException("Database does not support schemas", this, database);
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " (");
        for (String string : this.newColumnValues.keySet()) {
            stringBuffer.append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), string)).append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(" "));
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
        stringBuffer.append(") VALUES (");
        for (String string : this.newColumnValues.keySet()) {
            Object object = this.newColumnValues.get(string);
            if (object == null || object.toString().equals("NULL")) {
                stringBuffer.append("NULL");
            } else if (object instanceof String && database.shouldQuoteValue((String)object)) {
                stringBuffer.append("'").append(database.escapeStringForDatabase((String)object)).append("'");
            } else if (object instanceof Date) {
                stringBuffer.append(database.getDateLiteral((Date)object));
            } else if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    stringBuffer.append(database.getTrueBooleanValue());
                } else {
                    stringBuffer.append(database.getFalseBooleanValue());
                }
            } else {
                stringBuffer.append(object);
            }
            stringBuffer.append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(" "));
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

