/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.log.LogFactory;

public class DropTableStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private boolean cascadeConstraints;

    public DropTableStatement(String string, String string2, boolean bl) {
        this.schemaName = string;
        this.tableName = string2;
        this.cascadeConstraints = bl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isCascadeConstraints() {
        return this.cascadeConstraints;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP TABLE ").append(database.escapeTableName(this.getSchemaName(), this.getTableName()));
        if (this.isCascadeConstraints()) {
            if (database instanceof DerbyDatabase || database instanceof DB2Database || database instanceof MSSQLDatabase || database instanceof FirebirdDatabase || database instanceof SQLiteDatabase || database instanceof SybaseASADatabase) {
                LogFactory.getLogger().info("Database does not support drop with cascade");
            } else if (database instanceof OracleDatabase) {
                stringBuffer.append(" CASCADE CONSTRAINTS");
            } else {
                stringBuffer.append(" CASCADE");
            }
        }
        return stringBuffer.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

