/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.FirebirdDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropPrimaryKeyStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String constraintName;

    public DropPrimaryKeyStatement(String string, String string2, String string3) {
        this.schemaName = string;
        this.tableName = string2;
        this.constraintName = string3;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (this.getConstraintName() == null && (database instanceof MSSQLDatabase || database instanceof PostgresDatabase || database instanceof FirebirdDatabase)) {
            throw new StatementNotSupportedOnDatabaseException("Database requires a constraint name to drop the primary key", this, database);
        }
        if (database instanceof MSSQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP CONSTRAINT " + database.escapeConstraintName(this.getConstraintName());
        }
        if (database instanceof PostgresDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP CONSTRAINT " + database.escapeConstraintName(this.getConstraintName());
        }
        if (database instanceof FirebirdDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP CONSTRAINT " + database.escapeConstraintName(this.getConstraintName());
        }
        if (database instanceof OracleDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP PRIMARY KEY DROP INDEX";
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP PRIMARY KEY";
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

