/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropIndexStatement
implements SqlStatement {
    private String indexName;
    private String tableSchemaName;
    private String tableName;

    public DropIndexStatement(String string, String string2, String string3) {
        this.tableSchemaName = string2;
        this.indexName = string;
        this.tableName = string3;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        String string = this.getTableSchemaName();
        if (string != null && !database.supportsSchemas()) {
            throw new StatementNotSupportedOnDatabaseException("Database does not support schemas", this, database);
        }
        if (database instanceof MySQLDatabase) {
            if (this.getTableName() == null) {
                throw new StatementNotSupportedOnDatabaseException("tableName is required", this, database);
            }
            return "DROP INDEX " + database.escapeIndexName(null, this.getIndexName()) + " ON " + database.escapeTableName(string, this.getTableName());
        }
        if (database instanceof MSSQLDatabase) {
            if (this.getTableName() == null) {
                throw new StatementNotSupportedOnDatabaseException("tableName is required", this, database);
            }
            return "DROP INDEX " + database.escapeTableName(string, this.getTableName()) + "." + database.escapeIndexName(null, this.getIndexName());
        }
        return "DROP INDEX " + database.escapeIndexName(null, this.getIndexName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

