/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;

public class DeleteStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String whereClause;
    private List<Object> whereParameters = new ArrayList<Object>();

    public DeleteStatement(String string, String string2) {
        this.schemaName = string;
        this.tableName = string2;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public DeleteStatement setWhereClause(String string) {
        this.whereClause = string;
        return this;
    }

    public void addWhereParameter(Object object) {
        this.whereParameters.add(object);
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }

    public String getSqlStatement(Database database) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + database.escapeTableName(this.getSchemaName(), this.getTableName()));
        if (this.whereClause != null) {
            String string = " WHERE " + this.whereClause;
            for (Object object : this.whereParameters) {
                string = string.replaceFirst("\\?", this.convertToString(object, database));
            }
            stringBuffer.append(" ").append(string);
        }
        return stringBuffer.toString();
    }

    private String convertToString(Object object, Database database) {
        String string = object == null ? "NULL" : (object instanceof String && database.shouldQuoteValue((String)object) ? "'" + object + "'" : (object instanceof Date ? database.getDateLiteral((Date)object) : (object instanceof Boolean ? (((Boolean)object).booleanValue() ? database.getTrueBooleanValue() : database.getFalseBooleanValue()) : object.toString())));
        return string;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }
}

