/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class CreateViewStatement
implements SqlStatement {
    private String schemaName;
    private String viewName;
    private String selectQuery;
    private boolean replaceIfExists;

    public CreateViewStatement(String string, String string2, String string3, boolean bl) {
        this.schemaName = string;
        this.viewName = string2;
        this.selectQuery = string3;
        this.replaceIfExists = bl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public boolean isReplaceIfExists() {
        return this.replaceIfExists;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        String string;
        if ((database instanceof HsqlDatabase || database instanceof DB2Database || database instanceof CacheDatabase || database instanceof MSSQLDatabase || database instanceof DerbyDatabase || database instanceof SybaseASADatabase) && this.replaceIfExists) {
            throw new StatementNotSupportedOnDatabaseException("replaceIfExists not supported", this, database);
        }
        if (database instanceof FirebirdDatabase) {
            string = this.replaceIfExists ? "RECREATE VIEW" : "RECREATE VIEW";
        } else {
            if (database instanceof SybaseASADatabase && this.getSelectQuery().toLowerCase().startsWith("create view")) {
                return this.getSelectQuery();
            }
            string = "CREATE " + (this.replaceIfExists ? "OR REPLACE " : "") + "VIEW";
        }
        return string + " " + database.escapeViewName(this.getSchemaName(), this.getViewName()) + " AS " + this.getSelectQuery();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

