/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.ForeignKeyConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UniqueConstraint;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String tablespace;
    private List<String> columns = new ArrayList<String>();
    private Set<String> autoIncrementColumns = new HashSet<String>();
    private Map<String, String> columnTypes = new HashMap<String, String>();
    private Map<String, String> defaultValues = new HashMap<String, String>();
    private PrimaryKeyConstraint primaryKeyConstraint;
    private Set<String> notNullColumns = new HashSet<String>();
    private Set<ForeignKeyConstraint> foreignKeyConstraints = new HashSet<ForeignKeyConstraint>();
    private Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();

    public CreateTableStatement(String string, String string2) {
        this.schemaName = string;
        this.tableName = string2;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public CreateTableStatement setTablespace(String string) {
        this.tablespace = string;
        return this;
    }

    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public Set<ForeignKeyConstraint> getForeignKeyConstraints() {
        return this.foreignKeyConstraints;
    }

    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public Set<String> getNotNullColumns() {
        return this.notNullColumns;
    }

    public CreateTableStatement addPrimaryKeyColumn(String string, String string2, String string3, String string4, ColumnConstraint ... columnConstraintArray) {
        PrimaryKeyConstraint primaryKeyConstraint = new PrimaryKeyConstraint(string4);
        primaryKeyConstraint.addColumns(string);
        ArrayList<ColumnConstraint> arrayList = new ArrayList<ColumnConstraint>();
        arrayList.addAll(Arrays.asList(columnConstraintArray));
        arrayList.add(new NotNullConstraint(string));
        arrayList.add(primaryKeyConstraint);
        this.addColumn(string, string2, string3, arrayList.toArray(new ColumnConstraint[arrayList.size()]));
        return this;
    }

    public CreateTableStatement addColumn(String string, String string2) {
        return this.addColumn(string, string2, (String)null, new ColumnConstraint[0]);
    }

    public CreateTableStatement addColumn(String string, String string2, String string3) {
        return this.addColumn(string, string2, string3, new ColumnConstraint[0]);
    }

    public CreateTableStatement addColumn(String string, String string2, ColumnConstraint ... columnConstraintArray) {
        return this.addColumn(string, string2, (String)null, columnConstraintArray);
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    public CreateTableStatement addColumn(String string, String string2, String string3, ColumnConstraint ... columnConstraintArray) {
        this.getColumns().add(string);
        this.columnTypes.put(string, string2);
        if (string3 != null) {
            this.defaultValues.put(string, string3);
        }
        if (columnConstraintArray != null) {
            for (ColumnConstraint columnConstraint : columnConstraintArray) {
                if (columnConstraint instanceof PrimaryKeyConstraint) {
                    if (this.getPrimaryKeyConstraint() == null) {
                        this.primaryKeyConstraint = (PrimaryKeyConstraint)columnConstraint;
                        continue;
                    }
                    for (String string4 : ((PrimaryKeyConstraint)columnConstraint).getColumns()) {
                        this.getPrimaryKeyConstraint().addColumns(string4);
                    }
                    continue;
                }
                if (columnConstraint instanceof NotNullConstraint) {
                    ((NotNullConstraint)columnConstraint).setColumnName(string);
                    this.getNotNullColumns().add(string);
                    continue;
                }
                if (columnConstraint instanceof ForeignKeyConstraint) {
                    ((ForeignKeyConstraint)columnConstraint).setColumn(string);
                    this.getForeignKeyConstraints().add((ForeignKeyConstraint)columnConstraint);
                    continue;
                }
                if (columnConstraint instanceof UniqueConstraint) {
                    ((UniqueConstraint)columnConstraint).addColumns(string);
                    this.getUniqueConstraints().add((UniqueConstraint)columnConstraint);
                    continue;
                }
                if (columnConstraint instanceof AutoIncrementConstraint) {
                    this.autoIncrementColumns.add(string);
                    continue;
                }
                throw new RuntimeException("Unknown constraint type: " + columnConstraint.getClass().getName());
            }
        }
        return this;
    }

    @Override
    public String getSqlStatement(Database database) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ").append(database.escapeTableName(this.getSchemaName(), this.getTableName())).append(" ");
        stringBuffer.append("(");
        Iterator<String> iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = this.autoIncrementColumns.contains(object);
            stringBuffer.append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), (String)object));
            stringBuffer.append(" ").append(database.getColumnType(this.columnTypes.get(object), bl));
            if (database instanceof SQLiteDatabase && this.getPrimaryKeyConstraint() != null && this.getPrimaryKeyConstraint().getColumns().size() == 1 && this.getPrimaryKeyConstraint().getColumns().contains(object) && bl) {
                String string = StringUtils.trimToNull(this.getPrimaryKeyConstraint().getConstraintName());
                if (string == null) {
                    string = database.generatePrimaryKeyName(this.getTableName());
                }
                stringBuffer.append(" CONSTRAINT ");
                stringBuffer.append(database.escapeConstraintName(string));
                stringBuffer.append(" PRIMARY KEY AUTOINCREMENT");
            }
            if (this.getDefaultValue((String)object) != null) {
                if (database instanceof MSSQLDatabase) {
                    stringBuffer.append(" CONSTRAINT ").append(((MSSQLDatabase)database).generateDefaultConstraintName(this.tableName, (String)object));
                }
                stringBuffer.append(" DEFAULT ");
                stringBuffer.append(this.getDefaultValue((String)object));
            }
            if (bl && database.getAutoIncrementClause() != null && !database.getAutoIncrementClause().equals("")) {
                if (database.supportsAutoIncrement()) {
                    stringBuffer.append(" ").append(database.getAutoIncrementClause()).append(" ");
                } else {
                    LogFactory.getLogger().log(Level.WARNING, database.getProductName() + " does not support autoincrement columns as request for " + database.escapeTableName(this.getSchemaName(), this.getTableName()));
                }
            }
            if (this.getNotNullColumns().contains(object)) {
                stringBuffer.append(" NOT NULL");
            } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
                stringBuffer.append(" NULL");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(",");
        if (!(database instanceof SQLiteDatabase && this.getPrimaryKeyConstraint() != null && this.getPrimaryKeyConstraint().getColumns().size() == 1 && this.autoIncrementColumns.contains(this.getPrimaryKeyConstraint().getColumns().get(0)) || this.getPrimaryKeyConstraint() == null || this.getPrimaryKeyConstraint().getColumns().size() <= 0)) {
            object = StringUtils.trimToNull(this.getPrimaryKeyConstraint().getConstraintName());
            if (object == null) {
                object = database.generatePrimaryKeyName(this.getTableName());
            }
            stringBuffer.append(" CONSTRAINT ");
            stringBuffer.append(database.escapeConstraintName((String)object));
            stringBuffer.append(" PRIMARY KEY (");
            stringBuffer.append(database.escapeColumnNameList(StringUtils.join(this.getPrimaryKeyConstraint().getColumns(), ", ")));
            stringBuffer.append(")");
            stringBuffer.append(",");
        }
        for (ForeignKeyConstraint foreignKeyConstraint : this.getForeignKeyConstraints()) {
            stringBuffer.append(" CONSTRAINT ").append(database.escapeConstraintName(foreignKeyConstraint.getForeignKeyName())).append(" FOREIGN KEY (").append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), foreignKeyConstraint.getColumn())).append(") REFERENCES ").append(foreignKeyConstraint.getReferences());
            if (foreignKeyConstraint.isDeleteCascade()) {
                stringBuffer.append(" ON DELETE CASCADE");
            }
            if (foreignKeyConstraint.isInitiallyDeferred()) {
                stringBuffer.append(" INITIALLY DEFERRED");
            }
            if (foreignKeyConstraint.isDeferrable()) {
                stringBuffer.append(" DEFERRABLE");
            }
            stringBuffer.append(",");
        }
        for (UniqueConstraint uniqueConstraint : this.getUniqueConstraints()) {
            if (uniqueConstraint.getConstraintName() != null) {
                stringBuffer.append(" CONSTRAINT ");
                stringBuffer.append(database.escapeConstraintName(uniqueConstraint.getConstraintName()));
            }
            stringBuffer.append(" UNIQUE (");
            stringBuffer.append(database.escapeColumnNameList(StringUtils.join(uniqueConstraint.getColumns(), ", ")));
            stringBuffer.append("),");
        }
        object = stringBuffer.toString().replaceFirst(",\\s*$", "") + ")";
        if (this.getTablespace() != null && database.supportsTablespaces()) {
            object = database instanceof MSSQLDatabase || database instanceof SybaseASADatabase ? (String)object + " ON " + this.getTablespace() : (database instanceof DB2Database ? (String)object + " IN " + this.getTablespace() : (String)object + " TABLESPACE " + this.getTablespace());
        }
        return object;
    }

    public String getDefaultValue(String string) {
        return this.defaultValues.get(string);
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    public CreateTableStatement addColumnConstraint(NotNullConstraint notNullConstraint) {
        this.getNotNullColumns().add(notNullConstraint.getColumnName());
        return this;
    }

    public CreateTableStatement addColumnConstraint(ForeignKeyConstraint foreignKeyConstraint) {
        this.getForeignKeyConstraints().add(foreignKeyConstraint);
        return this;
    }

    public CreateTableStatement addColumnConstraint(UniqueConstraint uniqueConstraint) {
        this.getUniqueConstraints().add(uniqueConstraint);
        return this;
    }

    public CreateTableStatement addColumnConstraint(AutoIncrementConstraint autoIncrementConstraint) {
        this.autoIncrementColumns.add(autoIncrementConstraint.getColumnName());
        return this;
    }
}

