/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class CreateSequenceStatement
implements SqlStatement {
    private String schemaName;
    private String sequenceName;
    private Integer startValue;
    private Integer incrementBy;
    private Integer maxValue;
    private Integer minValue;
    private Boolean ordered;

    public CreateSequenceStatement(String string, String string2) {
        this.schemaName = string;
        this.sequenceName = string2;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public Integer getStartValue() {
        return this.startValue;
    }

    public CreateSequenceStatement setStartValue(Integer n) {
        this.startValue = n;
        return this;
    }

    public Integer getIncrementBy() {
        return this.incrementBy;
    }

    public CreateSequenceStatement setIncrementBy(Integer n) {
        this.incrementBy = n;
        return this;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public CreateSequenceStatement setMaxValue(Integer n) {
        this.maxValue = n;
        return this;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public CreateSequenceStatement setMinValue(Integer n) {
        this.minValue = n;
        return this;
    }

    public Boolean getOrdered() {
        return this.ordered;
    }

    public CreateSequenceStatement setOrdered(Boolean bl) {
        this.ordered = bl;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE SEQUENCE ");
        stringBuffer.append(database.escapeSequenceName(this.getSchemaName(), this.getSequenceName()));
        if (this.getStartValue() != null) {
            if (database instanceof FirebirdDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Firebird does not support creating sequences with startValue", this, database);
            }
            stringBuffer.append(" START WITH ").append(this.getStartValue());
        }
        if (this.getIncrementBy() != null) {
            if (database instanceof FirebirdDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Firebird does not support creating sequences with increments", this, database);
            }
            stringBuffer.append(" INCREMENT BY ").append(this.getIncrementBy());
        }
        if (this.getMinValue() != null) {
            if (database instanceof FirebirdDatabase || database instanceof HsqlDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Database does not support creating sequences with minValue", this, database);
            }
            stringBuffer.append(" MINVALUE ").append(this.getMinValue());
        }
        if (this.getMaxValue() != null) {
            if (database instanceof FirebirdDatabase || database instanceof HsqlDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Database does not support creating sequences with maxValue", this, database);
            }
            stringBuffer.append(" MAXVALUE ").append(this.getMaxValue());
        }
        if (this.getOrdered() != null) {
            if (database instanceof OracleDatabase || database instanceof DB2Database || database instanceof MaxDBDatabase) {
                if (this.getOrdered().booleanValue()) {
                    stringBuffer.append(" ORDER");
                }
            } else {
                throw new StatementNotSupportedOnDatabaseException("Database does not support creating sequences with 'order'", this, database);
            }
        }
        return stringBuffer.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return database.supportsSequences();
    }
}

