/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Arrays;
import java.util.Iterator;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.util.StringUtils;

public class CreateIndexStatement
implements SqlStatement {
    private String tableSchemaName;
    private String indexName;
    private String tableName;
    private String[] columns;
    private String tablespace;
    private Boolean unique;

    public CreateIndexStatement(String string, String string2, String string3, Boolean bl, String ... stringArray) {
        this.indexName = string;
        this.tableSchemaName = string2;
        this.tableName = string3;
        this.columns = stringArray;
        this.unique = bl;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public CreateIndexStatement setTablespace(String string) {
        this.tablespace = string;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        if (this.unique != null && this.unique.booleanValue()) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append("INDEX ");
        stringBuffer.append(database.escapeIndexName(null, this.getIndexName())).append(" ON ");
        stringBuffer.append(database.escapeTableName(this.getTableSchemaName(), this.getTableName())).append("(");
        Iterator<String> iterator = Arrays.asList(this.getColumns()).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuffer.append(database.escapeColumnName(this.getTableSchemaName(), this.getTableName(), string));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        if (StringUtils.trimToNull(this.getTablespace()) != null && database.supportsTablespaces()) {
            if (database instanceof MSSQLDatabase || database instanceof SybaseASADatabase) {
                stringBuffer.append(" ON ").append(this.getTablespace());
            } else if (database instanceof DB2Database) {
                stringBuffer.append(" IN ").append(this.getTablespace());
            } else {
                stringBuffer.append(" TABLESPACE ").append(this.getTablespace());
            }
        }
        return stringBuffer.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

