/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyRowsStatement
implements SqlStatement {
    private String sourceTable;
    private String targetTable;
    private List<ColumnConfig> copyColumns;

    public CopyRowsStatement(String string, String string2, List<ColumnConfig> list) {
        this.sourceTable = string;
        this.targetTable = string2;
        this.copyColumns = list;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public List<ColumnConfig> getCopyColumns() {
        return this.copyColumns;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    @Override
    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (database instanceof SQLiteDatabase) {
            stringBuffer.append("INSERT INTO `" + this.getTargetTable() + "` SELECT ");
            for (int i = 0; i < this.getCopyColumns().size(); ++i) {
                ColumnConfig columnConfig = this.getCopyColumns().get(i);
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("`" + columnConfig.getName() + "`");
            }
            stringBuffer.append(" FROM `" + this.getSourceTable() + "`");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return database instanceof SQLiteDatabase;
    }
}

