/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class AddForeignKeyConstraintStatement
implements SqlStatement {
    private String baseTableSchemaName;
    private String baseTableName;
    private String baseColumnNames;
    private String referencedTableSchemaName;
    private String referencedTableName;
    private String referencedColumnNames;
    private String constraintName;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private Integer deleteRule;
    private Integer updateRule;

    public AddForeignKeyConstraintStatement(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.baseTableSchemaName = string2;
        this.baseTableName = string3;
        this.baseColumnNames = string4;
        this.referencedTableSchemaName = string5;
        this.referencedTableName = string6;
        this.referencedColumnNames = string7;
        this.constraintName = string;
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public String getBaseColumnNames() {
        return this.baseColumnNames;
    }

    public String getReferencedTableSchemaName() {
        return this.referencedTableSchemaName;
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public String getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public AddForeignKeyConstraintStatement setDeferrable(boolean bl) {
        this.deferrable = bl;
        return this;
    }

    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public AddForeignKeyConstraintStatement setInitiallyDeferred(boolean bl) {
        this.initiallyDeferred = bl;
        return this;
    }

    public AddForeignKeyConstraintStatement setUpdateRule(Integer n) {
        this.updateRule = n;
        return this;
    }

    public AddForeignKeyConstraintStatement setDeleteRule(Integer n) {
        this.deleteRule = n;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        String string = "ALTER TABLE " + database.escapeTableName(this.getBaseTableSchemaName(), this.getBaseTableName()) + " ADD CONSTRAINT " + database.escapeConstraintName(this.getConstraintName()) + " FOREIGN KEY (" + database.escapeColumnNameList(this.getBaseColumnNames()) + ") REFERENCES " + database.escapeTableName(this.getReferencedTableSchemaName(), this.getReferencedTableName()) + "(" + database.escapeColumnNameList(this.getReferencedColumnNames()) + ")";
        if (this.updateRule != null) {
            switch (this.updateRule) {
                case 0: {
                    string = string + " ON UPDATE CASCADE";
                    break;
                }
                case 2: {
                    string = string + " ON UPDATE SET NULL";
                    break;
                }
                case 4: {
                    string = string + " ON UPDATE SET DEFAULT";
                    break;
                }
                case 1: {
                    if (!database.supportsRestrictForeignKeys()) break;
                    string = string + " ON UPDATE RESTRICT";
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        if (this.deleteRule != null) {
            switch (this.deleteRule) {
                case 0: {
                    string = string + " ON DELETE CASCADE";
                    break;
                }
                case 2: {
                    string = string + " ON DELETE SET NULL";
                    break;
                }
                case 4: {
                    string = string + " ON DELETE SET DEFAULT";
                    break;
                }
                case 1: {
                    if (!database.supportsRestrictForeignKeys()) break;
                    string = string + " ON DELETE RESTRICT";
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        if (this.isDeferrable() || this.isInitiallyDeferred()) {
            if (!database.supportsInitiallyDeferrableColumns()) {
                throw new StatementNotSupportedOnDatabaseException("Database does not support deferrable foreign keys", this, database);
            }
            if (this.isDeferrable()) {
                string = string + " DEFERRABLE";
            }
            if (this.isInitiallyDeferred()) {
                string = string + " INITIALLY DEFERRED";
            }
        }
        return string;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

