/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.H2Database;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnType;
    private Object defaultValue;
    private Set<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();

    public AddColumnStatement(String string, String string2, String string3, String string4, Object object, ColumnConstraint ... columnConstraintArray) {
        this.schemaName = string;
        this.tableName = string2;
        this.columnName = string3;
        this.columnType = string4;
        this.defaultValue = object;
        if (columnConstraintArray != null) {
            this.constraints.addAll(Arrays.asList(columnConstraintArray));
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public Set<ColumnConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (this.isPrimaryKey() && (database instanceof CacheDatabase || database instanceof H2Database || database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof SQLiteDatabase)) {
            throw new StatementNotSupportedOnDatabaseException("Adding primary key columns is not supported", this, database);
        }
        String string = "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ADD " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " " + database.getColumnType(this.getColumnType(), this.isAutoIncrement());
        if (this.defaultClauseBeforeNotNull(database)) {
            string = string + this.getDefaultClause(database);
        }
        if (this.primaryKeyBeforeNotNull(database) && this.isPrimaryKey()) {
            string = string + " PRIMARY KEY";
        }
        if (this.isAutoIncrement()) {
            string = string + " " + database.getAutoIncrementClause();
        }
        if (!this.isNullable()) {
            string = string + " NOT NULL";
        } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
            string = string + " NULL";
        }
        if (!this.primaryKeyBeforeNotNull(database) && this.isPrimaryKey()) {
            string = string + " PRIMARY KEY";
        }
        if (!this.defaultClauseBeforeNotNull(database)) {
            string = string + this.getDefaultClause(database);
        }
        return string;
    }

    private boolean primaryKeyBeforeNotNull(Database database) {
        return !(database instanceof HsqlDatabase);
    }

    public boolean isAutoIncrement() {
        for (ColumnConstraint columnConstraint : this.getConstraints()) {
            if (!(columnConstraint instanceof AutoIncrementConstraint)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryKey() {
        for (ColumnConstraint columnConstraint : this.getConstraints()) {
            if (!(columnConstraint instanceof PrimaryKeyConstraint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    private boolean defaultClauseBeforeNotNull(Database database) {
        return database instanceof OracleDatabase || database instanceof HsqlDatabase || database instanceof DerbyDatabase || database instanceof DB2Database || database instanceof FirebirdDatabase;
    }

    private String getDefaultClause(Database database) {
        String string = "";
        if (this.getDefaultValue() != null) {
            if (database instanceof MSSQLDatabase) {
                string = string + " CONSTRAINT " + ((MSSQLDatabase)database).generateDefaultConstraintName(this.tableName, this.getColumnName());
            }
            string = string + " DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        return string;
    }

    public boolean isNullable() {
        if (this.isPrimaryKey()) {
            return false;
        }
        for (ColumnConstraint columnConstraint : this.getConstraints()) {
            if (!(columnConstraint instanceof NotNullConstraint)) continue;
            return false;
        }
        return true;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

