/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.UnsupportedDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedDatabase
extends AbstractDatabase {
    private String dateTimeType;

    @Override
    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.dateTimeType = this.findDateTypeType();
        if (this.currentDateTimeFunction == null) {
            this.currentDateTimeFunction = this.findCurrentDateTimeFunction();
        }
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return null;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return null;
    }

    @Override
    public String getBooleanType() {
        return "INT";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return this.dateTimeType;
    }

    private String findDateTypeType() {
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().getMetaData().getTypeInfo();
            while (resultSet.next()) {
                if (resultSet.getInt("DATA_TYPE") != 93) continue;
                String string = resultSet.getString("TYPE_NAME");
                return string;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return "DATETIME";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return false;
    }

    @Override
    public String getDefaultDriver(String string) {
        return null;
    }

    @Override
    public String getProductName() {
        return "Unsupported Database (" + this.getDatabaseProductName() + ")";
    }

    @Override
    public String getTypeName() {
        return this.getDatabaseProductName().toLowerCase().replaceAll("\\W", "");
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    private String findCurrentDateTimeFunction() {
        try {
            String[] stringArray;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            for (String string5 : stringArray = this.getConnection().getMetaData().getTimeDateFunctions().split(",")) {
                String string6 = string5.trim().toUpperCase();
                if (string6.endsWith("TIMESTAMP")) {
                    string4 = string5.trim();
                }
                if (string6.endsWith("DATETIME")) {
                    string3 = string5.trim();
                }
                if (string6.endsWith("DATE")) {
                    string2 = string5.trim();
                }
                if (!"NOW".equals(string6)) continue;
                string = string5.trim();
            }
            if (string != null) {
                return "{fn " + string + "()" + "}";
            }
            if (string4 != null) {
                return "{fn " + string4 + "()" + "}";
            }
            if (string3 != null) {
                return "{fn " + string3 + "()" + "}";
            }
            if (string2 != null) {
                return "{fn " + string2 + "()" + "}";
            }
            return "CURRENT_TIMESTAMP";
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    @Override
    protected boolean canCreateChangeLogTable() throws JDBCException {
        try {
            int n = this.getConnection().getMetaData().getMaxIndexLength();
            return n == 0 || n >= 555 && super.canCreateChangeLogTable();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new UnsupportedDatabaseSnapshot(this, set, string);
    }
}

