/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SybaseConnectionDelegate;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.JDBCException;

public class SybaseDatabase
extends MSSQLDatabase {
    public SybaseDatabase() {
        this.systemTablesAndViews.add("sysquerymetrics");
    }

    public String getProductName() {
        return "Sybase SQL Server";
    }

    public String getTypeName() {
        return "sybase";
    }

    public void setConnection(Connection connection) {
        super.setConnection(new SybaseConnectionDelegate(connection));
    }

    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:sybase")) {
            return "com.sybase.jdbc3.jdbc.SybDriver";
        }
        if (string.startsWith("jdbc:jtds:sybase")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        return null;
    }

    public boolean supportsDDLInTransaction() {
        return false;
    }

    protected SqlStatement getCreateChangeLogSQL() {
        return new RawSqlStatement("CREATE TABLE " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " (ID VARCHAR(150) NOT NULL, " + "AUTHOR VARCHAR(150) NOT NULL, " + "FILENAME VARCHAR(255) NOT NULL, " + "DATEEXECUTED " + this.getDateTimeType() + " NOT NULL, " + "MD5SUM VARCHAR(32) NULL, " + "DESCRIPTION VARCHAR(255) NULL, " + "COMMENTS VARCHAR(255) NULL, " + "TAG VARCHAR(255) NULL, " + "LIQUIBASE VARCHAR(10) NULL, " + "PRIMARY KEY(ID, AUTHOR, FILENAME))");
    }

    protected SqlStatement getCreateChangeLogLockSQL() {
        return new RawSqlStatement("CREATE TABLE " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()) + " (ID INT NOT NULL PRIMARY KEY, LOCKED " + this.getBooleanType() + " NOT NULL, LOCKGRANTED " + this.getDateTimeType() + " NULL, LOCKEDBY VARCHAR(255) NULL)");
    }

    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        String string = this.getDatabaseProductName(connection);
        return "Sybase SQL Server".equals(string) || "sql server".equals(string);
    }

    public boolean supportsTablespaces() {
        return true;
    }
}

