/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.SybaseASADatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseASADatabase
extends AbstractDatabase {
    private static final Set<String> systemTablesAndViews = new HashSet<String>();

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new SybaseASADatabaseSnapshot(this, set, string);
    }

    @Override
    public String escapeIndexName(String string, String string2) {
        return this.escapeName(string2);
    }

    @Override
    public String getBlobType() {
        return "LONG BINARY";
    }

    @Override
    public String getBooleanType() {
        return "BIT";
    }

    @Override
    public String getClobType() {
        return "LONG VARCHAR";
    }

    @Override
    public String getCurrencyType() {
        return "MONEY";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "now()";
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public String getDefaultDriver(String string) {
        return "com.sybase.jdbc3.jdbc.SybDriver";
    }

    @Override
    public String getProductName() {
        return "Sybase ASAny";
    }

    @Override
    public String getTypeName() {
        return "asany";
    }

    @Override
    public String getUUIDType() {
        return "UNIQUEIDENTIFIER";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return "Adaptive Server Anywhere".equalsIgnoreCase(this.getDatabaseProductName(connection)) || "SQL Anywhere".equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return null;
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        if (string == null) {
            return "DBA";
        }
        return string;
    }

    @Override
    public String getDefaultSchemaName() {
        return super.getDefaultSchemaName();
    }

    @Override
    public String escapeColumnName(String string, String string2, String string3) {
        return "[" + string3 + "]";
    }

    @Override
    public String getViewDefinition(String string, String string2) throws JDBCException {
        return super.getViewDefinition(string, string2);
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public String convertRequestedSchemaToCatalog(String string) throws JDBCException {
        return this.getDefaultCatalogName();
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return systemTablesAndViews;
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public String getAutoIncrementClause() {
        return "default autoincrement";
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        String string3 = "select viewtext from sysviews where upper(viewname)='" + string2.toUpperCase() + "' and upper(vcreator) = '" + string.toUpperCase() + '\'';
        return new RawSqlStatement(string3);
    }

    @Override
    public void setAutoCommit(boolean bl) throws JDBCException {
        if (bl || super.isAutoCommit()) {
            super.setAutoCommit(bl);
        }
    }

    private String escapeName(String string) {
        return '[' + string + ']';
    }

    static {
        systemTablesAndViews.add("dummy");
        systemTablesAndViews.add("sysarticle");
        systemTablesAndViews.add("sysarticlecol");
        systemTablesAndViews.add("sysarticlecols");
        systemTablesAndViews.add("sysarticles");
        systemTablesAndViews.add("sysattribute");
        systemTablesAndViews.add("sysattributename");
        systemTablesAndViews.add("syscapabilities");
        systemTablesAndViews.add("syscapability");
        systemTablesAndViews.add("syscapabilityname");
        systemTablesAndViews.add("syscatalog");
        systemTablesAndViews.add("syscolauth");
        systemTablesAndViews.add("syscollation");
        systemTablesAndViews.add("syscollationmappings");
        systemTablesAndViews.add("syscolperm");
        systemTablesAndViews.add("syscolstat");
        systemTablesAndViews.add("syscolstats");
        systemTablesAndViews.add("syscolumn");
        systemTablesAndViews.add("syscolumns");
        systemTablesAndViews.add("sysdomain");
        systemTablesAndViews.add("sysevent");
        systemTablesAndViews.add("syseventtype");
        systemTablesAndViews.add("sysextent");
        systemTablesAndViews.add("sysexternlogins");
        systemTablesAndViews.add("sysfile");
        systemTablesAndViews.add("sysfkcol");
        systemTablesAndViews.add("sysforeignkey");
        systemTablesAndViews.add("sysforeignkeys");
        systemTablesAndViews.add("sysgroup");
        systemTablesAndViews.add("sysgroups");
        systemTablesAndViews.add("sysindex");
        systemTablesAndViews.add("sysindexes");
        systemTablesAndViews.add("sysinfo");
        systemTablesAndViews.add("sysixcol");
        systemTablesAndViews.add("sysjar");
        systemTablesAndViews.add("sysjarcomponent");
        systemTablesAndViews.add("sysjavaclass");
        systemTablesAndViews.add("syslogin");
        systemTablesAndViews.add("sysoptblock");
        systemTablesAndViews.add("sysoption");
        systemTablesAndViews.add("sysoptions");
        systemTablesAndViews.add("sysoptjoinstrategy");
        systemTablesAndViews.add("sysoptorder");
        systemTablesAndViews.add("sysoptorders");
        systemTablesAndViews.add("sysoptplans");
        systemTablesAndViews.add("sysoptquantifier");
        systemTablesAndViews.add("sysoptrequest");
        systemTablesAndViews.add("sysoptrewrite");
        systemTablesAndViews.add("sysoptstat");
        systemTablesAndViews.add("sysoptstrategies");
        systemTablesAndViews.add("sysprocauth");
        systemTablesAndViews.add("sysprocedure");
        systemTablesAndViews.add("sysprocparm");
        systemTablesAndViews.add("sysprocparms");
        systemTablesAndViews.add("sysprocperm");
        systemTablesAndViews.add("syspublication");
        systemTablesAndViews.add("syspublications");
        systemTablesAndViews.add("sysremoteoption");
        systemTablesAndViews.add("sysremoteoptions");
        systemTablesAndViews.add("sysremoteoptiontype");
        systemTablesAndViews.add("sysremotetype");
        systemTablesAndViews.add("sysremotetypes");
        systemTablesAndViews.add("sysremoteuser");
        systemTablesAndViews.add("sysremoteusers");
        systemTablesAndViews.add("sysschedule");
        systemTablesAndViews.add("sysservers");
        systemTablesAndViews.add("syssqlservertype");
        systemTablesAndViews.add("syssubscription");
        systemTablesAndViews.add("syssubscriptions");
        systemTablesAndViews.add("syssync");
        systemTablesAndViews.add("syssyncdefinitions");
        systemTablesAndViews.add("syssyncpublicationdefaults");
        systemTablesAndViews.add("syssyncs");
        systemTablesAndViews.add("syssyncsites");
        systemTablesAndViews.add("syssyncsubscriptions");
        systemTablesAndViews.add("syssynctemplates");
        systemTablesAndViews.add("syssyncusers");
        systemTablesAndViews.add("systabauth");
        systemTablesAndViews.add("systable");
        systemTablesAndViews.add("systableperm");
        systemTablesAndViews.add("systrigger");
        systemTablesAndViews.add("systriggers");
        systemTablesAndViews.add("systypemap");
        systemTablesAndViews.add("sysuserauth");
        systemTablesAndViews.add("sysuserlist");
        systemTablesAndViews.add("sysusermessages");
        systemTablesAndViews.add("sysuseroptions");
        systemTablesAndViews.add("sysuserperm");
        systemTablesAndViews.add("sysuserperms");
        systemTablesAndViews.add("sysusertype");
        systemTablesAndViews.add("sysviews");
    }
}

