/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import liquibase.change.ColumnConfig;
import liquibase.change.CreateTableChange;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.sql.CopyRowsStatement;
import liquibase.database.sql.CreateIndexStatement;
import liquibase.database.sql.DropTableStatement;
import liquibase.database.sql.ReindexStatement;
import liquibase.database.sql.RenameTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.Index;
import liquibase.database.structure.SQLiteDatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.ISODateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends AbstractDatabase {
    private Set<String> systemTables = new HashSet<String>();
    public static final String PRODUCT_NAME = "SQLite";

    public SQLiteDatabase() {
        this.systemTables.add("sqlite_sequence");
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getBooleanType() {
        return "BOOLEAN";
    }

    @Override
    public String getClobType() {
        return "TEXT";
    }

    @Override
    public String getCurrencyType() {
        return "REAL";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    public String getDateTimeType() {
        return "TEXT";
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:sqlite:")) {
            return "SQLite.JDBCDriver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getTypeName() {
        return "sqlite";
    }

    @Override
    public String getUUIDType() {
        return "TEXT";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public String getViewDefinition(String string, String string2) throws JDBCException {
        return null;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    public String getTrigger(String string, String string2) {
        return "CREATE TRIGGER insert_" + string + "_timeEnter AFTER  INSERT ON " + string + " BEGIN" + " UPDATE " + string + " SET " + string2 + " = DATETIME('NOW')" + " WHERE rowid = new.rowid END ";
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public String getColumnType(String string, Boolean bl) {
        String string2 = string.equals("INTEGER") || string.toLowerCase(Locale.ENGLISH).contains("int") || string.toLowerCase(Locale.ENGLISH).contains("bit") ? "INTEGER" : (string.equals("TEXT") || string.toLowerCase(Locale.ENGLISH).contains("uuid") || string.toLowerCase(Locale.ENGLISH).contains("uniqueidentifier") || string.toLowerCase(Locale.ENGLISH).equals("uniqueidentifier") || string.toLowerCase(Locale.ENGLISH).equals("datetime") || string.toLowerCase(Locale.ENGLISH).contains("timestamp") || string.toLowerCase(Locale.ENGLISH).contains("char") || string.toLowerCase(Locale.ENGLISH).contains("clob") || string.toLowerCase(Locale.ENGLISH).contains("text") ? "TEXT" : (string.equals("REAL") || string.toLowerCase(Locale.ENGLISH).contains("float") ? "REAL" : (string.toLowerCase(Locale.ENGLISH).contains("blob") || string.toLowerCase(Locale.ENGLISH).contains("binary") ? "BLOB" : (string.toLowerCase(Locale.ENGLISH).contains("boolean") || string.toLowerCase(Locale.ENGLISH).contains("binary") ? "BOOLEAN" : super.getColumnType(string, bl)))));
        return string2;
    }

    public static Collection<SqlStatement> getAlterTableStatements(AlterTableVisitor alterTableVisitor, Database database, String string, String string2) throws UnsupportedChangeException, JDBCException {
        Vector<SqlStatement> vector = new Vector<SqlStatement>();
        SQLiteDatabaseSnapshot sQLiteDatabaseSnapshot = new SQLiteDatabaseSnapshot(database);
        Table table = sQLiteDatabaseSnapshot.getTable(string2);
        Vector<ColumnConfig> vector2 = new Vector<ColumnConfig>();
        Vector<ColumnConfig> vector3 = new Vector<ColumnConfig>();
        if (table != null) {
            for (Column column : table.getColumns()) {
                ColumnConfig iterator2;
                ColumnConfig columnConfig = new ColumnConfig(column);
                if (alterTableVisitor.createThisColumn(columnConfig)) {
                    vector2.add(columnConfig);
                }
                if (!alterTableVisitor.copyThisColumn(iterator2 = new ColumnConfig(column))) continue;
                vector3.add(iterator2);
            }
        }
        for (ColumnConfig columnConfig : alterTableVisitor.getColumnsToAdd()) {
            ColumnConfig columnConfig2;
            ColumnConfig columnConfig3 = new ColumnConfig(columnConfig);
            if (alterTableVisitor.createThisColumn(columnConfig3)) {
                vector2.add(columnConfig3);
            }
            if (!alterTableVisitor.copyThisColumn(columnConfig2 = new ColumnConfig(columnConfig))) continue;
            vector3.add(columnConfig2);
        }
        Vector vector4 = new Vector();
        for (Index index : sQLiteDatabaseSnapshot.getIndexes()) {
            if (!index.getTable().getName().equalsIgnoreCase(string2) || !alterTableVisitor.createThisIndex(index)) continue;
            vector4.add(index);
        }
        String string3 = string2 + "_temporary";
        vector.add(new RenameTableStatement(string, string2, string3));
        CreateTableChange createTableChange = new CreateTableChange();
        createTableChange.setSchemaName(string);
        createTableChange.setTableName(string2);
        for (ColumnConfig columnConfig : vector2) {
            createTableChange.addColumn(columnConfig);
        }
        vector.addAll(Arrays.asList(createTableChange.generateStatements(database)));
        vector.add(new CopyRowsStatement(string3, string2, vector3));
        vector.add(new DropTableStatement(string, string3, false));
        vector.add(new ReindexStatement(string, string2));
        Iterator iterator = vector4.iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            vector.add(new CreateIndexStatement(index.getName(), string, string2, index.isUnique(), index.getColumns().toArray(new String[index.getColumns().size()])));
        }
        return vector;
    }

    @Override
    public String getConnectionUsername() throws JDBCException {
        try {
            String string = this.getConnection().getMetaData().getUserName();
            if (string == null) {
                string = "liquibase";
            }
            return string;
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    protected Set<String> getSystemTablesAndViews() {
        return this.systemTables;
    }

    @Override
    public String getDateLiteral(Timestamp timestamp) {
        return this.getDateLiteral(new ISODateFormat().format(timestamp).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new SQLiteDatabaseSnapshot(this);
    }

    public static interface AlterTableVisitor {
        public ColumnConfig[] getColumnsToAdd();

        public boolean copyThisColumn(ColumnConfig var1);

        public boolean createThisColumn(ColumnConfig var1);

        public boolean createThisIndex(Index var1);
    }
}

