/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import liquibase.database.DatabaseConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLConnectionDelegate
implements DatabaseConnection {
    Connection con;

    public SQLConnectionDelegate(Connection connection) {
        this.con = connection;
    }

    public Connection getWrappedConnection() {
        return this.con;
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.rollback();
        this.con.close();
    }

    @Override
    public void commit() throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.commit();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.con.createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.con.createStatement(n, n2, n3);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.con.createStatement(n, n2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.con.nativeSQL(string);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.con.prepareCall(string, n, n2, n3);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.con.prepareCall(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.con.prepareCall(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.con.prepareStatement(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.con.prepareStatement(string, n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.con.prepareStatement(string, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.con.prepareStatement(string, nArray);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.con.prepareStatement(string, stringArray);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.con.prepareStatement(string);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.rollback();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.con.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.con.setCatalog(string);
    }

    public void setHoldability(int n) throws SQLException {
        this.con.setHoldability(n);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.con.setReadOnly(bl);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.con.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.con.setTransactionIsolation(n);
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.con.setTypeMap(map);
    }

    @Override
    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SQLConnectionDelegate)) {
            return false;
        }
        SQLConnectionDelegate sQLConnectionDelegate = (SQLConnectionDelegate)object;
        try {
            return this.getUnderlyingConnection().getMetaData().getURL().equals(sQLConnectionDelegate.getUnderlyingConnection().getMetaData().getURL()) && this.getUnderlyingConnection().getMetaData().getUserName().equals(sQLConnectionDelegate.getUnderlyingConnection().getMetaData().getUserName());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public int hashCode() {
        return this.getUnderlyingConnection().hashCode();
    }
}

