/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.PostgresDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "PostgreSQL";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private String defaultDatabaseSchemaName;
    private String[] reservedWords = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASYMMETRIC", "AUTHORIZATION", "BETWEEN", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NEW", "NOT", "NOTNULL", "NULL", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUTER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RETURNING", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "SYMMETRIC", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VERBOSE", "WHEN", "WHERE"};

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getTypeName() {
        return "postgresql";
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    @Override
    public String getBooleanType() {
        return "BOOLEAN";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "TEXT";
    }

    @Override
    public String getBlobType() {
        return "BYTEA";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "NOW()";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        block5: {
            if (this.defaultDatabaseSchemaName == null) {
                try {
                    List<String> list = this.getSearchPaths();
                    if (list == null || list.size() <= 0) break block5;
                    for (String string : list) {
                        if (string == null || string.length() <= 0) continue;
                        this.defaultDatabaseSchemaName = string;
                        if (this.defaultDatabaseSchemaName.equals("$user") && this.getConnectionUsername() != null) {
                            this.defaultDatabaseSchemaName = !this.schemaExists(this.getConnectionUsername()) ? null : this.getConnectionUsername();
                        }
                        if (this.defaultDatabaseSchemaName == null) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    log.log(Level.SEVERE, "Failed to get default catalog name from postgres", exception);
                }
            }
        }
        return this.defaultDatabaseSchemaName;
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return "public";
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toLowerCase();
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toLowerCase();
    }

    @Override
    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return new RawSqlStatement("SELECT relname AS SEQUENCE_NAME FROM pg_class, pg_namespace WHERE relkind='S' AND pg_class.relnamespace = pg_namespace.oid AND nspname = '" + this.convertRequestedSchemaToSchema(string) + "' " + "AND 'nextval(''" + (string == null ? "" : string + ".") + "'||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval(''" + (string == null ? "" : string + ".") + "\"'||relname||'\"''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval('''||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null)");
    }

    @Override
    public boolean isSystemTable(String string, String string2, String string3) {
        return super.isSystemTable(string, string2, string3) || "pg_catalog".equals(string2) || "pg_toast".equals(string2) || string3.endsWith("_seq") || string3.endsWith("_key") || string3.endsWith("_pkey") || string3.startsWith("idx_") || string3.startsWith("pk_");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("select definition from pg_views where viewname='" + string2 + "' AND schemaname='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public String getColumnType(String string, Boolean bl) {
        if (string.startsWith("java.sql.Types.VARCHAR")) {
            return string.replace("java.sql.Types.", "");
        }
        String string2 = super.getColumnType(string, bl);
        if (string2.startsWith("TEXT(")) {
            return this.getClobType();
        }
        if (string2.toLowerCase().startsWith("float8")) {
            return "FLOAT8";
        }
        if (string2.toLowerCase().startsWith("float4")) {
            return "FLOAT4";
        }
        if (bl != null && bl.booleanValue()) {
            if ("integer".equals(string2.toLowerCase())) {
                return "serial";
            }
            if ("bigint".equals(string2.toLowerCase()) || "bigserial".equals(string2.toLowerCase())) {
                return "bigserial";
            }
            return "serial";
        }
        return string2;
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object != null && object instanceof String) {
            object = ((String)object).replaceAll("'::[\\w\\s]+$", "'");
            if (n == 91 || n == 92 || n == 93) {
                object = ((String)object).replaceFirst("-\\d+$", "");
            }
        }
        return super.convertDatabaseValueToJavaObject(object, n, n2, n3);
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        if (string == null) {
            return this.getDefaultCatalogName();
        }
        return StringUtils.trimToNull(string).toLowerCase();
    }

    @Override
    public String convertRequestedSchemaToCatalog(String string) throws JDBCException {
        return super.convertRequestedSchemaToCatalog(string);
    }

    @Override
    public String escapeTableName(String string, String string2) {
        if (StringUtils.trimToNull(string2) != null && (this.hasCaseProblems(string2) || this.isReservedWord(string2))) {
            return super.escapeTableName(string, "\"" + string2 + "\"");
        }
        return super.escapeTableName(string, string2);
    }

    @Override
    public String escapeConstraintName(String string) {
        if (string == null) {
            return null;
        }
        if (this.hasCaseProblems(string) || this.isReservedWord(string)) {
            return "\"" + string + "\"";
        }
        return super.escapeConstraintName(string);
    }

    @Override
    public String escapeColumnName(String string, String string2, String string3) {
        if (this.hasCaseProblems(string3) || this.isReservedWord(string3)) {
            return "\"" + string3 + "\"";
        }
        return string3;
    }

    private boolean hasCaseProblems(String string) {
        return string.matches(".*[A-Z].*") && string.matches(".*[a-z].*");
    }

    private boolean isReservedWord(String string) {
        for (int i = 0; i != this.reservedWords.length; ++i) {
            if (!this.reservedWords[i].toLowerCase().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private List<String> getSearchPaths() {
        ArrayList<String> arrayList = null;
        try {
            String string;
            Statement statement;
            ResultSet resultSet;
            DatabaseConnection databaseConnection = this.getConnection();
            if (databaseConnection != null && (resultSet = (statement = databaseConnection.createStatement(1004, 1007)).executeQuery("SHOW search_path")).next() && (string = resultSet.getString(1)) != null) {
                String[] stringArray = string.split("\\,");
                arrayList = new ArrayList<String>();
                for (String string2 : stringArray) {
                    if ((string2 = string2.trim()).equals("\"$user\"")) {
                        string2 = "$user";
                    }
                    arrayList.add(string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.log(Level.SEVERE, "Failed to get default catalog name from postgres", exception);
        }
        return arrayList;
    }

    private boolean catalogExists(String string) throws SQLException {
        if (string != null) {
            return this.runExistsQuery("select count(*) from information_schema.schemata where catalog_name='" + string + "'");
        }
        return false;
    }

    private boolean schemaExists(String string) throws SQLException {
        if (string != null) {
            return this.runExistsQuery("select count(*) from information_schema.schemata where schema_name='" + string + "'");
        }
        return false;
    }

    private boolean runExistsQuery(String string) throws SQLException {
        Integer n;
        DatabaseConnection databaseConnection = this.getConnection();
        Statement statement = databaseConnection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(string);
        return resultSet.next() && (n = Integer.valueOf(resultSet.getInt(1))) != null && n > 0;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new PostgresDatabaseSnapshot(this, set, string);
    }

    @Override
    public String escapeSequenceName(String string, String string2) {
        if (StringUtils.trimToNull(string2) != null && (this.hasCaseProblems(string2) || this.isReservedWord(string2))) {
            return super.escapeSequenceName(string, "\"" + string2 + "\"");
        }
        return super.escapeSequenceName(string, string2);
    }

    @Override
    protected Object convertToCorrectJavaType(String string, int n, int n2, int n3) throws ParseException {
        Object object = super.convertToCorrectJavaType(string, n, n2, n3);
        if (object != null && object instanceof String && ((String)object).startsWith("NULL::")) {
            return null;
        }
        return object;
    }

    @Override
    public String escapeColumnNameList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : string.split(",")) {
            String string3;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (this.hasCaseProblems(string3 = string2.trim()) || this.isReservedWord(string3)) {
                string3 = "\"" + string3 + "\"";
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }
}

