/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.text.ParseException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.OracleDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "oracle";

    @Override
    public void setConnection(Connection connection) {
        try {
            Method method = connection.getClass().getMethod("setRemarksReporting", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)connection, true);
        }
        catch (Exception exception) {
            log.info("Could not set remarks reporting on OracleDatabase: " + exception.getMessage());
        }
        super.setConnection(connection);
    }

    @Override
    public String getProductName() {
        return "Oracle";
    }

    @Override
    public String getTypeName() {
        return PRODUCT_NAME;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getBooleanType() {
        return "NUMBER(1)";
    }

    @Override
    public String getCurrencyType() {
        return "NUMBER(15, 2)";
    }

    @Override
    public String getUUIDType() {
        return "RAW(16)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public String getDateType() {
        return "DATE";
    }

    @Override
    public String getTimeType() {
        return "DATE";
    }

    @Override
    public String getBigIntType() {
        return "NUMBER(19,0)";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:oracle")) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "SYSDATE";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public String getDateLiteral(String string) {
        String string2 = super.getDateLiteral(string);
        if (this.isDateOnly(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("to_date(");
            stringBuffer.append(string2);
            stringBuffer.append(", 'YYYY-MM-DD')");
            return stringBuffer.toString();
        }
        if (this.isTimeOnly(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("to_date(");
            stringBuffer.append(string2);
            stringBuffer.append(", 'HH24:MI:SS')");
            return stringBuffer.toString();
        }
        if (this.isDateTime(string)) {
            string2 = string2.substring(0, string2.lastIndexOf(46)) + "'";
            StringBuffer stringBuffer = new StringBuffer(26);
            stringBuffer.append("to_date(");
            stringBuffer.append(string2);
            stringBuffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
            return stringBuffer.toString();
        }
        return "UNSUPPORTED:" + string;
    }

    @Override
    public SqlStatement getSelectChangeLogLockSQL() throws JDBCException {
        return new RawSqlStatement((super.getSelectChangeLogLockSQL().getSqlStatement(this) + " for update").toUpperCase());
    }

    @Override
    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return new RawSqlStatement("SELECT SEQUENCE_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = '" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public boolean isSystemTable(String string, String string2, String string3) {
        if (super.isSystemTable(string, string2, string3)) {
            return true;
        }
        if (string3.startsWith("BIN$")) {
            return true;
        }
        if (string3.startsWith("AQ$")) {
            return true;
        }
        return string3.startsWith("DR$");
    }

    @Override
    public boolean shouldQuoteValue(String string) {
        return super.shouldQuoteValue(string) && !string.startsWith("to_date(") && !string.equalsIgnoreCase(this.getCurrentDateTimeFunction());
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("SELECT TEXT FROM ALL_VIEWS WHERE upper(VIEW_NAME)='" + string2.toUpperCase() + "' AND OWNER='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object != null && object instanceof String) {
            if (n == 91 || n == 92 || n == 93) {
                object = ((String)object).indexOf("YYYY-MM-DD HH") > 0 ? ((String)object).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD HH24:MI:SS'\\)$", "") : (((String)object).indexOf("YYYY-MM-DD") > 0 ? ((String)object).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD'\\)$", "") : ((String)object).replaceFirst("^to_date\\('", "").replaceFirst("', 'HH24:MI:SS'\\)$", ""));
            }
            object = ((String)object).replaceFirst("'\\s*$", "'");
        }
        return super.convertDatabaseValueToJavaObject(object, n, n2, n3);
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new OracleDatabaseSnapshot(this, set, string);
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }
}

