/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.MySqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "MySQL";

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getTypeName() {
        return "mysql";
    }

    @Override
    public String getConnectionUsername() throws JDBCException {
        return super.getConnectionUsername().replaceAll("\\@.*", "");
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:mysql")) {
            return "com.mysql.jdbc.Driver";
        }
        return null;
    }

    @Override
    public String getBooleanType() {
        return "TINYINT(1)";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "TEXT";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "NOW()";
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getConcatSql(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CONCAT_WS(");
        for (String string : stringArray) {
            stringBuffer.append(string).append(", ");
        }
        return stringBuffer.toString().replaceFirst(", $", ")");
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        if (string == null) {
            return this.getDefaultDatabaseSchemaName();
        }
        return string;
    }

    @Override
    public String convertRequestedSchemaToCatalog(String string) throws JDBCException {
        return string;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("select view_definition from information_schema.views where table_name='" + string2 + "' AND table_schema='" + string + "'");
    }

    @Override
    public String escapeTableName(String string, String string2) {
        if (string != null) {
            return "`" + string + "`.`" + string2 + "`";
        }
        return "`" + string2 + "`";
    }

    @Override
    public String escapeConstraintName(String string) {
        if (string == null) {
            return null;
        }
        return "`" + string + "`";
    }

    @Override
    public String escapeColumnName(String string, String string2, String string3) {
        return "`" + string3 + "`";
    }

    @Override
    public String escapeColumnNameList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : string.split(",")) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("`").append(string2.trim()).append("`");
        }
        return stringBuffer.toString();
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new MySqlDatabaseSnapshot(this, set, string);
    }
}

