/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.MaxDBDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxDBDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "SAP DB";
    protected Set<String> systemTablesAndViews = new HashSet<String>();

    public MaxDBDatabase() {
        this.systemTablesAndViews.add("---");
        this.systemTablesAndViews.add("ACTIVECONFIGURATION");
        this.systemTablesAndViews.add("BACKUPTHREADS");
        this.systemTablesAndViews.add("CACHESTATISTICS");
        this.systemTablesAndViews.add("CATALOGCACHESTATISTICS");
        this.systemTablesAndViews.add("COMMANDCACHESTATISTICS");
        this.systemTablesAndViews.add("COMMANDCACHESTATISTICSRESET");
        this.systemTablesAndViews.add("COMMANDSTATISTICS");
        this.systemTablesAndViews.add("COMMANDSTATISTICSRESET");
        this.systemTablesAndViews.add("CONSISTENTVIEWS");
        this.systemTablesAndViews.add("DATACACHE");
        this.systemTablesAndViews.add("DATASTATISTICS");
        this.systemTablesAndViews.add("DATASTATISTICSRESET");
        this.systemTablesAndViews.add("DATAVOLUMES");
        this.systemTablesAndViews.add("DATASTATISTICSRESET");
        this.systemTablesAndViews.add("FILEDIRECTORIES");
        this.systemTablesAndViews.add("FILES");
        this.systemTablesAndViews.add("HOTSTANDBYCOMPONENT");
        this.systemTablesAndViews.add("HOTSTANDBYGROUP");
        this.systemTablesAndViews.add("INSTANCE");
        this.systemTablesAndViews.add("IOBUFFERCACHES");
        this.systemTablesAndViews.add("IOTHREADSTATISTICS");
        this.systemTablesAndViews.add("IOTHREADSTATISTICSRESET");
        this.systemTablesAndViews.add("INDEXSIZE");
        this.systemTablesAndViews.add("INDEXSTORAGEDETAILS");
        this.systemTablesAndViews.add("LOGINFORMATION");
        this.systemTablesAndViews.add("LOGQUEUESTATISTICS");
        this.systemTablesAndViews.add("LOGQUEUESTATISTICSRESET");
        this.systemTablesAndViews.add("LOGSTATISTICS");
        this.systemTablesAndViews.add("LOGSTATISTICSRESET");
        this.systemTablesAndViews.add("LOGVOLUMES");
        this.systemTablesAndViews.add("MACHINECONFIGURATION");
        this.systemTablesAndViews.add("MACHINEUTILIZATION");
        this.systemTablesAndViews.add("MEMORYALLOCATORSTATISTICS");
        this.systemTablesAndViews.add("OPTIMIZERINFORMATION");
        this.systemTablesAndViews.add("READERWRITERLOCKINFORMATION");
        this.systemTablesAndViews.add("READERWRITERLOCKSTATISTICS");
        this.systemTablesAndViews.add("READERWRITERLOCKSTATISTICSRESET");
        this.systemTablesAndViews.add("READERWRITERLOCKWAITINGTASKS");
        this.systemTablesAndViews.add("REGIONINFORMATION");
        this.systemTablesAndViews.add("REGIONSTATISTICS");
        this.systemTablesAndViews.add("REGIONSTATISTICSRESET");
        this.systemTablesAndViews.add("RESTARTINFORMATION");
        this.systemTablesAndViews.add("SCHEMASIZE");
        this.systemTablesAndViews.add("SERVERTASKS");
        this.systemTablesAndViews.add("SESSIONS");
        this.systemTablesAndViews.add("SNAPSHOTS");
        this.systemTablesAndViews.add("SPINLOCKPOOLSTATISTICS");
        this.systemTablesAndViews.add("SPINLOCKPOOLSTATISTICSRESET");
        this.systemTablesAndViews.add("SPINLOCKSTATISTICS");
        this.systemTablesAndViews.add("SPINLOCKSTATISTICSRESET");
        this.systemTablesAndViews.add("TABLESIZE");
        this.systemTablesAndViews.add("TABLESTORAGEDETAILS");
        this.systemTablesAndViews.add("TASKGROUPSTATISTICS");
        this.systemTablesAndViews.add("TASKGROUPSTATISTICSRESET");
        this.systemTablesAndViews.add("TASKLOADBALANCINGINFORMATION");
        this.systemTablesAndViews.add("TASKLOADBALANCINGTASKGROUPSTATES");
        this.systemTablesAndViews.add("TASKLOADBALANCINGTASKMOVES");
        this.systemTablesAndViews.add("TRANSACTIONHISTORY");
        this.systemTablesAndViews.add("TRANSACTIONS");
        this.systemTablesAndViews.add("UNLOADEDSTATEMENTS");
        this.systemTablesAndViews.add("VERSION");
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public String getProductName() {
        return "MaxDB";
    }

    @Override
    public String getTypeName() {
        return "maxdb";
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getBooleanType() {
        return "BOOLEAN";
    }

    @Override
    public String getCurrencyType() {
        return "NUMERIC(15, 2)";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "LONG VARCHAR";
    }

    @Override
    public String getBlobType() {
        return "LONG BYTE";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public String getDateType() {
        return "DATE";
    }

    @Override
    public String getTimeType() {
        return "TIME";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:sapdb")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "TIMESTAMP";
    }

    @Override
    public String getTrueBooleanValue() {
        return "TRUE";
    }

    @Override
    public String getFalseBooleanValue() {
        return "FALSE";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return new RawSqlStatement("SELECT SEQUENCE_NAME FROM DOMAIN.SEQUENCES WHERE OWNER = '" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public boolean isSystemTable(String string, String string2, String string3) {
        if (super.isSystemTable(string, string2, string3)) {
            return true;
        }
        if ("DOMAIN".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("SYSINFO".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("SYSLOADER".equalsIgnoreCase(string2)) {
            return true;
        }
        return "SYSDBA".equalsIgnoreCase(string2);
    }

    @Override
    public boolean isSystemView(String string, String string2, String string3) {
        if (super.isSystemView(string, string2, string3)) {
            return true;
        }
        if ("DOMAIN".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("SYSINFO".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("SYSLOADER".equalsIgnoreCase(string2)) {
            return true;
        }
        return "SYSDBA".equalsIgnoreCase(string2);
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("SELECT DEFINITION FROM DOMAIN.VIEWDEFS WHERE upper(VIEWNAME)='" + string2.toUpperCase() + "' AND OWNER='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public String convertJavaObjectToString(Object object) {
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.getTrueBooleanValue();
            }
            return this.getFalseBooleanValue();
        }
        return super.convertJavaObjectToString(object);
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new MaxDBDatabaseSnapshot(this, set, string);
    }
}

