/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.MSSQLDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "Microsoft SQL Server";
    protected Set<String> systemTablesAndViews = new HashSet<String>();

    @Override
    public String getProductName() {
        return "Microsoft SQL";
    }

    @Override
    public String getTypeName() {
        return "mssql";
    }

    public MSSQLDatabase() {
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("syscomments");
        this.systemTablesAndViews.add("sysdepends");
        this.systemTablesAndViews.add("sysfilegroups");
        this.systemTablesAndViews.add("sysfiles");
        this.systemTablesAndViews.add("sysfiles1");
        this.systemTablesAndViews.add("sysforeignkeys");
        this.systemTablesAndViews.add("sysfulltextcatalogs");
        this.systemTablesAndViews.add("sysfulltextnotify");
        this.systemTablesAndViews.add("sysindexes");
        this.systemTablesAndViews.add("sysindexkeys");
        this.systemTablesAndViews.add("sysmembers");
        this.systemTablesAndViews.add("sysobjects");
        this.systemTablesAndViews.add("syspermissions");
        this.systemTablesAndViews.add("sysproperties");
        this.systemTablesAndViews.add("sysprotects");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("systypes");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("syssegments");
        this.systemTablesAndViews.add("sysconstraints");
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:sqlserver")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (string.startsWith("jdbc:jtds:sqlserver")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        return null;
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public String getTimeType() {
        return "DATETIME";
    }

    @Override
    public String getDateType() {
        return "SMALLDATETIME";
    }

    @Override
    public String getBooleanType() {
        return "BIT";
    }

    @Override
    public String getCurrencyType() {
        return "MONEY";
    }

    @Override
    public String getUUIDType() {
        return "UNIQUEIDENTIFIER";
    }

    @Override
    public String getClobType() {
        return "TEXT";
    }

    @Override
    public String getBlobType() {
        return "IMAGE";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "GETDATE()";
    }

    @Override
    public String getAutoIncrementClause() {
        return "IDENTITY";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return null;
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getConcatSql(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string).append(" + ");
        }
        return stringBuffer.toString().replaceFirst(" \\+ $", "");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean isSystemTable(String string, String string2, String string3) {
        return super.isSystemTable(string, string2, string3) || string2.equals("sys");
    }

    @Override
    public boolean isSystemView(String string, String string2, String string3) {
        return super.isSystemView(string, string2, string3) || string2.equals("sys");
    }

    public String generateDefaultConstraintName(String string, String string2) {
        return "DF_" + string + "_" + string2;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            if (((String)object).startsWith("('")) {
                object = ((String)object).replaceFirst("^\\('", "").replaceFirst("'\\)$", "");
            } else if (((String)object).startsWith("((")) {
                object = ((String)object).replaceFirst("^\\(\\(", "").replaceFirst("\\)\\)$", "");
            }
        }
        object = super.convertDatabaseValueToJavaObject(object, n, n2, n3);
        return object;
    }

    @Override
    public String escapeTableName(String string, String string2) {
        if (string == null) {
            return "[" + string2 + "]";
        }
        return "[" + string + "].[" + string2 + "]";
    }

    @Override
    public String escapeConstraintName(String string) {
        if (string == null) {
            return null;
        }
        return "[" + string + "]";
    }

    @Override
    public String convertRequestedSchemaToCatalog(String string) throws JDBCException {
        return this.getDefaultCatalogName();
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        if (string == null) {
            return "dbo";
        }
        return string;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        String string3 = "select view_definition from INFORMATION_SCHEMA.VIEWS where upper(table_name)='" + string2.toUpperCase() + "'";
        string3 = string3 + " and table_schema='" + this.convertRequestedSchemaToSchema(string) + "'";
        string3 = string3 + " and table_catalog='" + this.getDefaultCatalogName() + "'";
        return new RawSqlStatement(string3);
    }

    @Override
    public String getColumnType(String string, Boolean bl) {
        String string2 = super.getColumnType(string, bl);
        if (bl != null && bl.booleanValue()) {
            string2 = string2.replaceFirst(" identity$", "");
        }
        return string2;
    }

    @Override
    public String getDateLiteral(String string) {
        return super.getDateLiteral(string).replace(' ', 'T');
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new MSSQLDatabaseSnapshot(this, set, string);
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }
}

