/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.HsqlConnectionDelegate;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.HsqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDatabase
extends AbstractDatabase {
    private static String START_CONCAT = "CONCAT(";
    private static String END_CONCAT = ")";
    private static String SEP_CONCAT = ", ";
    private static List keywords = Arrays.asList("ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASENSITIVE", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOOLEAN", "BOTH", "BY", "CALL", "CALLED", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOB", "CLOSE", "COLLATE", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONSTRAINT", "CONTINUE", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GRO", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_T", "CURRENT_USER", "CURSOR", "CYCLE", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DEREF", "DESCRIBE", "DETERMINISTIC", "DISCONNECT", "DISTINCT", "DO", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "ELSEIF", "END", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FALSE", "FETCH", "FILTER", "FLOAT", "FOR", "FOREIGN", "FREE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", "GROUP", "GROUPING", "HANDLER", "HAVING", "HOLD", "HOUR", "IDENTITY", "IF", "IMMEDIATE", "IN", "INDICATOR", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "LANGUAGE", "LARGE", "LATERAL", "LEADING", "LEAVE", "LEFT", "LIKE", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOOP", "MATCH", "MEMBER", "MERGE", "METHOD", "MINUTE", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NO", "NONE", "NOT", "NULL", "NUMERIC", "OF", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PARAMETER", "PARTITION", "PRECISION", "PREPARE", "PRIMARY", "PROCEDURE", "RANGE", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELEASE", "REPEAT", "RESIGNAL", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "SAVEPOINT", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SELECT", "SENSITIVE", "SESSION_USER", "SET", "SIGNAL", "SIMILAR", "SMALLINT", "SOME", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATIC", "SUBMULTISET", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UNTIL", "UPDATE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "WHEN", "WHENEVER", "WHERE", "WHILE", "WINDOW", "WITH", "WITHIN", "WITHOUT", "YEAR", "ALIAS", "AUTOCOMMIT", "CACHED", "CHECKPOINT", "EXPLAIN", "IGNORECASE", "INDEX", "LOGSIZE", "MATCHED", "MAXROWS", "MEMORY", "MINUS", "NEXT", "OPENBRACKET", "PASSWORD", "PLAN", "PROPERTY", "READONLY", "REFERENTIAL_INTEGRITY", "RENAME", "RESTART", "SCRIPT", "SCRIPTFORMAT", "SEMICOLON", "SEQUENCE", "SHUTDOWN", "SOURCE", "TEMP", "TEXT", "VIEW", "WRITE_DELAY", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "DEFRAG", "INCREMENT", "TOCHAR", "DATABASE", "SCHEMA", "ROLE", "DOW", "INITIAL");

    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return "HSQL Database Engine".equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbcDriver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return "Hsqldb";
    }

    @Override
    public String getTypeName() {
        return "hsqldb";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return "PUBLIC";
    }

    @Override
    public String getBooleanType() {
        return "BOOLEAN";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "VARCHAR(36)";
    }

    @Override
    public String getClobType() {
        return "LONGVARCHAR";
    }

    @Override
    public String getBlobType() {
        return "LONGVARBINARY";
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "NOW()";
    }

    @Override
    public String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY IDENTITY";
    }

    @Override
    public String getConcatSql(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        return this.getConcatSql(Arrays.asList(stringArray));
    }

    private String getConcatSql(List<String> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return START_CONCAT + list.get(0) + SEP_CONCAT + this.getConcatSql(list.subList(1, list.size())) + END_CONCAT;
    }

    @Override
    public String getDateLiteral(String string) {
        String string2 = string;
        try {
            if (this.isDateTime(string)) {
                ISODateFormat iSODateFormat = new ISODateFormat();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                string2 = simpleDateFormat.format(iSODateFormat.parse(string));
            }
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Unexpected date format: " + string, parseException);
        }
        return "'" + string2 + "'";
    }

    @Override
    protected Date parseDate(String string) throws DateParseException {
        try {
            if (string.indexOf(" ") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").parse(string);
            }
            if (string.indexOf(":") > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(string);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(string);
        }
        catch (ParseException parseException) {
            throw new DateParseException(string);
        }
    }

    @Override
    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return new RawSqlStatement("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES WHERE SEQUENCE_SCHEMA = '" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public void setConnection(Connection connection) {
        super.setConnection(new HsqlConnectionDelegate(connection));
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.SYSTEM_VIEWS WHERE TABLE_NAME = '" + string2 + "' AND TABLE_SCHEMA='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        return super.convertRequestedSchemaToSchema(string).toUpperCase();
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new HsqlDatabaseSnapshot(this, set, string);
    }

    @Override
    public String escapeTableName(String string, String string2) {
        if (StringUtils.trimToNull(string) == null || !this.supportsSchemas()) {
            return this.escapeObjectName(string2);
        }
        return this.escapeObjectName(string + "." + this.escapeObjectName(string2));
    }

    @Override
    public String escapeColumnName(String string, String string2, String string3) {
        return super.escapeColumnName(string, string2, string3);
    }

    private String escapeObjectName(String string) {
        if (keywords.contains(string.toUpperCase())) {
            return "\"" + string + "\"";
        }
        return string;
    }
}

