/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import liquibase.database.HsqlDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;
import liquibase.util.StringUtils;

public class H2Database
extends HsqlDatabase {
    public String getProductName() {
        return "H2 Database";
    }

    public String getTypeName() {
        return "h2";
    }

    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:h2")) {
            return "org.h2.Driver";
        }
        return null;
    }

    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return "H2".equals(this.getDatabaseProductName(connection));
    }

    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return new RawSqlStatement("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA = '" + this.convertRequestedSchemaToSchema(string) + "' AND IS_GENERATED=FALSE");
    }

    public String getObjectEscapeCharacter() {
        return "`";
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public String getViewDefinition(String string, String string2) throws JDBCException {
        return super.getViewDefinition(string, string2).replaceFirst(".*?\n", "");
    }

    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = '" + string2 + "' AND TABLE_SCHEMA='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object != null && object instanceof String) {
            if (StringUtils.trimToEmpty((String)object).startsWith("(NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_")) {
                return null;
            }
            if (StringUtils.trimToNull((String)object) == null) {
                return null;
            }
        }
        return super.convertDatabaseValueToJavaObject(object, n, n2, n3);
    }

    protected Date parseDate(String string) throws DateParseException {
        try {
            if (string.indexOf(32) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").parse(string);
            }
            if (string.indexOf(58) > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(string);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(string);
        }
        catch (ParseException parseException) {
            throw new DateParseException(string);
        }
    }

    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    public boolean isLocalDatabase() throws JDBCException {
        String string = this.getConnectionURL();
        boolean bl = super.isLocalDatabase() || string.startsWith("jdbc:h2:file:") || string.startsWith("jdbc:h2:mem:") || string.startsWith("jdbc:h2:zip:") || string.startsWith("jdbc:h2:~");
        return bl;
    }
}

