/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.text.ParseException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DerbyConnectionDelegate;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.DerbyDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDatabase
extends AbstractDatabase {
    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return "Apache Derby".equalsIgnoreCase(this.getDatabaseProductName(connection));
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:derby")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return "Apache Derby";
    }

    @Override
    public String getTypeName() {
        return "derby";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getBooleanType() {
        return "SMALLINT";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    @Override
    public String getDateLiteral(String string) {
        if (this.isDateOnly(string)) {
            return "DATE(" + super.getDateLiteral(string) + ")";
        }
        if (this.isTimeOnly(string)) {
            return "TIME(" + super.getDateLiteral(string) + ")";
        }
        String string2 = super.getDateLiteral(string);
        int n = string2.length() - string2.indexOf(46) - 2;
        String string3 = "";
        for (int i = 6; i > n; --i) {
            string3 = string3 + "0";
        }
        return "TIMESTAMP(" + string2.replaceFirst("'$", string3 + "'") + ")";
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("select V.VIEWDEFINITION from SYS.SYSVIEWS V, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE  V.TABLEID=T.TABLEID AND T.SCHEMAID=S.SCHEMAID AND T.TABLETYPE='V' AND T.TABLENAME='" + string2 + "' AND S.SCHEMANAME='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public String getViewDefinition(String string, String string2) throws JDBCException {
        return super.getViewDefinition(string, string2).replaceFirst("CREATE VIEW \\w+ AS ", "");
    }

    @Override
    public void setConnection(Connection connection) {
        super.setConnection(new DerbyConnectionDelegate(connection));
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object != null && object instanceof String) {
            if (n == 93) {
                object = ((String)object).replaceFirst("^TIMESTAMP\\('", "").replaceFirst("'\\)", "");
            } else if (n == 91) {
                object = ((String)object).replaceFirst("^DATE\\('", "").replaceFirst("'\\)", "");
            } else if (n == 92) {
                object = ((String)object).replaceFirst("^TIME\\('", "").replaceFirst("'\\)", "");
            }
        }
        return super.convertDatabaseValueToJavaObject(object, n, n2, n3);
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new DerbyDatabaseSnapshot(this, set, string);
    }
}

