/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.H2Database;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.UnsupportedDatabase;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFactory {
    private static DatabaseFactory instance = new DatabaseFactory();
    private static final Logger log = LogFactory.getLogger();
    private List<Database> implementedDatabases = new ArrayList<Database>(Arrays.asList(new OracleDatabase(), new PostgresDatabase(), new MSSQLDatabase(), new MySQLDatabase(), new DerbyDatabase(), new HsqlDatabase(), new DB2Database(), new SybaseDatabase(), new H2Database(), new CacheDatabase(), new FirebirdDatabase(), new MaxDBDatabase(), new SQLiteDatabase(), new SybaseASADatabase()));

    private DatabaseFactory() {
    }

    public static DatabaseFactory getInstance() {
        return instance;
    }

    public List<Database> getImplementedDatabases() {
        return this.implementedDatabases;
    }

    public void addDatabaseImplementation(Database database) {
        this.implementedDatabases.add(0, database);
    }

    public Database findCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        Database database;
        Object object = null;
        boolean bl = false;
        for (Database database2 : this.getImplementedDatabases()) {
            object = database2;
            if (!object.isCorrectDatabaseImplementation(connection)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            try {
                log.warning("Unknown database: " + connection.getMetaData().getDatabaseProductName());
            }
            catch (SQLException sQLException) {
                throw new JDBCException(sQLException);
            }
            object = new UnsupportedDatabase();
        }
        try {
            database = (Database)object.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        database.setConnection(connection);
        return database;
    }

    public Database findCorrectDatabaseImplementation(DatabaseConnection databaseConnection) throws JDBCException {
        return this.findCorrectDatabaseImplementation(databaseConnection.getUnderlyingConnection());
    }

    public String findDefaultDriver(String string) {
        for (Database database : this.getImplementedDatabases()) {
            String string2 = database.getDefaultDriver(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }
}

