/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DB2DatabaseSnapshot;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2Database
extends AbstractDatabase {
    @Override
    public boolean isCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        return this.getDatabaseProductName(connection).startsWith("DB2");
    }

    @Override
    public String getDefaultDriver(String string) {
        if (string.startsWith("jdbc:db2")) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return "DB2";
    }

    @Override
    public String getTypeName() {
        return "db2";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "CURRENT TIMESTAMP";
    }

    @Override
    public String getBooleanType() {
        return "SMALLINT";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getDateLiteral(String string) {
        String string2 = super.getDateLiteral(string);
        if (this.isDateOnly(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DATE(");
            stringBuffer.append(string2);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isTimeOnly(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TIME(");
            stringBuffer.append(string2);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isDateTime(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TIMESTAMP(");
            stringBuffer.append(string2);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        return "UNSUPPORTED:" + string;
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL(19,4)";
    }

    @Override
    public String getUUIDType() {
        return "VARCHAR(36)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return new RawSqlStatement("SELECT SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES WHERE SEQTYPE='S' AND SEQSCHEMA = '" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public boolean shouldQuoteValue(String string) {
        return super.shouldQuoteValue(string) && !string.startsWith("\"SYSIBM\"");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        return new RawSqlStatement("select view_definition from SYSIBM.VIEWS where TABLE_NAME='" + string2 + "' and TABLE_SCHEMA='" + this.convertRequestedSchemaToSchema(string) + "'");
    }

    @Override
    public String getViewDefinition(String string, String string2) throws JDBCException {
        return super.getViewDefinition(string, string2).replaceFirst("CREATE VIEW \\w+ AS ", "");
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object != null && object instanceof String) {
            if (n == 93) {
                object = ((String)object).replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
            } else if (n == 92) {
                object = ((String)object).replaceFirst("^\"SYSIBM\".\"TIME\"\\('", "").replaceFirst("'\\)", "");
            } else if (n == 91) {
                object = ((String)object).replaceFirst("^\"SYSIBM\".\"DATE\"\\('", "").replaceFirst("'\\)", "");
            }
        }
        return super.convertDatabaseValueToJavaObject(object, n, n2, n3);
    }

    @Override
    protected Date parseDate(String string) throws DateParseException {
        try {
            if (string.indexOf(32) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string);
            }
            if (string.indexOf(46) > 0 && string.indexOf(45) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSSSSS").parse(string);
            }
            if (string.indexOf(58) > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(string);
            }
            if (string.indexOf(46) > 0) {
                return new SimpleDateFormat("HH.mm.ss").parse(string);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(string);
        }
        catch (ParseException parseException) {
            throw new DateParseException(string);
        }
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        if (string == null) {
            return this.getDefaultDatabaseSchemaName();
        }
        return string.toUpperCase();
    }

    @Override
    public String convertRequestedSchemaToCatalog(String string) throws JDBCException {
        return null;
    }

    @Override
    public String generatePrimaryKeyName(String string) {
        String string2 = super.generatePrimaryKeyName(string);
        if (string2.length() > 18) {
            string2 = string2.substring(0, 17);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isColumnAutoIncrement(String string, String string2, String string3) throws SQLException, JDBCException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getConnection().prepareStatement("SELECT IDENTITY FROM SYSCAT.COLUMNS WHERE TABSCHEMA = ? AND TABNAME = ? AND COLNAME = ? AND HIDDEN != 'S'");
            preparedStatement.setString(1, this.convertRequestedSchemaToSchema(string));
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString("IDENTITY");
                if (!string4.equalsIgnoreCase("Y")) continue;
                bl = true;
            }
            resultSet.close();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String string, Set<DiffStatusListener> set) throws JDBCException {
        return new DB2DatabaseSnapshot(this, set, string);
    }
}

