/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.change.DropSequenceChange;
import liquibase.change.DropTableChange;
import liquibase.change.DropViewChange;
import liquibase.change.RawSQLChange;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.SQLConnectionDelegate;
import liquibase.database.sql.AddColumnStatement;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.ComputedDateValue;
import liquibase.database.sql.ComputedNumericValue;
import liquibase.database.sql.CreateTableStatement;
import liquibase.database.sql.InsertStatement;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.TagDatabaseStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.database.template.JdbcOutputTemplate;
import liquibase.database.template.JdbcTemplate;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.lock.LockHandler;
import liquibase.log.LogFactory;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabase
implements Database {
    private DatabaseConnection connection;
    private String defaultSchemaName;
    protected static final Logger log = LogFactory.getLogger();
    protected String currentDateTimeFunction;
    private JdbcTemplate jdbcTemplate = new JdbcTemplate(this);
    private List<RanChangeSet> ranChangeSetList;
    private static Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);
    private String databaseChangeLogTableName = "DatabaseChangeLog".toUpperCase();
    private String databaseChangeLogLockTableName = "DatabaseChangeLogLock".toUpperCase();

    protected AbstractDatabase() {
    }

    @Override
    public DatabaseConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = new SQLConnectionDelegate(connection);
        try {
            this.connection.setAutoCommit(this.getAutoCommitMode());
        }
        catch (SQLException sQLException) {
            log.warning("Can not set auto commit to " + this.getAutoCommitMode() + " on connection");
        }
    }

    @Override
    public void setConnection(DatabaseConnection databaseConnection) {
        this.connection = databaseConnection;
        try {
            this.connection.setAutoCommit(this.getAutoCommitMode());
        }
        catch (SQLException sQLException) {
            log.warning("Can not set auto commit to " + this.getAutoCommitMode() + " on connection");
        }
    }

    @Override
    public boolean getAutoCommitMode() {
        return !this.supportsDDLInTransaction();
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        try {
            return this.connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Cannot get database name");
        }
    }

    @Override
    public String getDatabaseProductName(Connection connection) throws JDBCException {
        try {
            return connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String getDatabaseProductVersion() throws JDBCException {
        try {
            return this.connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws JDBCException {
        try {
            return this.connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws JDBCException {
        try {
            return this.connection.getMetaData().getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String getDriverName() throws JDBCException {
        try {
            return this.connection.getMetaData().getDriverName();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String getConnectionURL() throws JDBCException {
        try {
            return this.connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String getConnectionUsername() throws JDBCException {
        try {
            return this.connection.getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return null;
    }

    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return this.getConnectionUsername();
    }

    @Override
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public void setDefaultSchemaName(String string) throws JDBCException {
        this.defaultSchemaName = string;
    }

    protected Set<String> getSystemTablesAndViews() {
        return new HashSet<String>();
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public void setCurrentDateTimeFunction(String string) {
        if (string != null) {
            this.currentDateTimeFunction = string;
        }
    }

    @Override
    public String getColumnType(String string, Boolean bl) {
        String string2 = null;
        String string3 = null;
        if (string.startsWith("java.sql.Types") && string.contains("(")) {
            string3 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            string2 = string.substring(string.lastIndexOf(".") + 1, string.indexOf("("));
        } else if (string.startsWith("java.sql.Types")) {
            string2 = string.substring(string.lastIndexOf(".") + 1);
        } else if (string.contains("(")) {
            string3 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            string2 = string.substring(0, string.indexOf("("));
        } else {
            string2 = string;
        }
        String string4 = null;
        if (string.startsWith("java.sql.Types")) {
            string4 = this.getTypeFromMetaData(string2);
        }
        if (string4 == null) {
            if (string2.equalsIgnoreCase("BIGINT")) {
                string4 = this.getBigIntType();
            } else if (string2.equalsIgnoreCase("BLOB")) {
                string4 = this.getBlobType();
            } else if (string2.equalsIgnoreCase("BOOLEAN")) {
                string4 = this.getBooleanType();
            } else if (string2.equalsIgnoreCase("CHAR")) {
                string4 = this.getCharType();
            } else if (string2.equalsIgnoreCase("CLOB")) {
                string4 = this.getClobType();
            } else if (string2.equalsIgnoreCase("CURRENCY")) {
                string4 = this.getCurrencyType();
            } else if (string2.equalsIgnoreCase("DATE")) {
                string4 = this.getDateType();
            } else if (string2.equalsIgnoreCase("DATETIME")) {
                string4 = this.getDateTimeType();
            } else if (string2.equalsIgnoreCase("DOUBLE")) {
                string4 = this.getDoubleType();
            } else if (string2.equalsIgnoreCase("FLOAT")) {
                string4 = this.getFloatType();
            } else if (string2.equalsIgnoreCase("INT")) {
                string4 = this.getIntType();
            } else if (string2.equalsIgnoreCase("LONGVARBINARY")) {
                string4 = this.getBlobType();
            } else if (string2.equalsIgnoreCase("LONGVARCHAR")) {
                string4 = this.getClobType();
            } else if (string2.equalsIgnoreCase("TEXT")) {
                string4 = this.getClobType();
            } else if (string2.equalsIgnoreCase("TIME")) {
                string4 = this.getTimeType();
            } else if (string2.equalsIgnoreCase("TINYINT")) {
                string4 = this.getTinyIntType();
            } else if (string2.equalsIgnoreCase("UUID")) {
                string4 = this.getUUIDType();
            } else if (string2.equalsIgnoreCase("VARCHAR")) {
                string4 = this.getVarcharType();
            } else {
                return string;
            }
        }
        if (string3 == null) {
            return string4;
        }
        return string4 + "(" + string3 + ")";
    }

    private String getTypeFromMetaData(String string) {
        ResultSet resultSet = null;
        try {
            String string2;
            Integer n = (Integer)Class.forName("java.sql.Types").getDeclaredField(string).get(null);
            DatabaseConnection databaseConnection = this.getConnection();
            if (databaseConnection == null) {
                throw new RuntimeException("Cannot evaluate java.sql.Types without a connection");
            }
            resultSet = databaseConnection.getMetaData().getTypeInfo();
            while (resultSet.next()) {
                string2 = resultSet.getString("TYPE_NAME");
                int n2 = resultSet.getInt("DATA_TYPE");
                if (n != n2) continue;
                String string3 = string2;
                return string3;
            }
            string2 = null;
            return string2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public final String getColumnType(ColumnConfig columnConfig) {
        return this.getColumnType(columnConfig.getType(), columnConfig.isAutoIncrement());
    }

    @Override
    public String getFalseBooleanValue() {
        return "false";
    }

    @Override
    public String getTrueBooleanValue() {
        return "true";
    }

    @Override
    public String getDateLiteral(String string) {
        if (this.isDateOnly(string) || this.isTimeOnly(string)) {
            return "'" + string + "'";
        }
        if (this.isDateTime(string)) {
            return "'" + string.replace('T', ' ') + "'";
        }
        return "BAD_DATE_FORMAT:" + string;
    }

    @Override
    public String getDateLiteral(Timestamp timestamp) {
        return this.getDateLiteral(new ISODateFormat().format(timestamp).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(Date date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(Time time) {
        return this.getDateLiteral(new ISODateFormat().format(time).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(java.util.Date date) {
        if (date instanceof Date) {
            return this.getDateLiteral((Date)date);
        }
        if (date instanceof Time) {
            return this.getDateLiteral((Time)date);
        }
        if (date instanceof Timestamp) {
            return this.getDateLiteral((Timestamp)date);
        }
        if (date instanceof ComputedDateValue) {
            return date.toString();
        }
        throw new RuntimeException("Unexpected type: " + date.getClass().getName());
    }

    protected java.util.Date parseDate(String string) throws DateParseException {
        try {
            if (string.indexOf(" ") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string);
            }
            if (string.indexOf("T") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(string);
            }
            if (string.indexOf(":") > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(string);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(string);
        }
        catch (ParseException parseException) {
            throw new DateParseException(string);
        }
    }

    protected boolean isDateOnly(String string) {
        return string.length() == "yyyy-MM-dd".length();
    }

    protected boolean isDateTime(String string) {
        return string.length() >= "yyyy-MM-ddThh:mm:ss".length();
    }

    protected boolean isTimeOnly(String string) {
        return string.length() == "hh:mm:ss".length();
    }

    @Override
    public String getDateType() {
        return "DATE";
    }

    @Override
    public String getTimeType() {
        return "TIME";
    }

    @Override
    public String getBigIntType() {
        return "BIGINT";
    }

    @Override
    public String getCharType() {
        return "CHAR";
    }

    @Override
    public String getVarcharType() {
        return "VARCHAR";
    }

    @Override
    public String getFloatType() {
        return "FLOAT";
    }

    @Override
    public String getDoubleType() {
        return "DOUBLE";
    }

    @Override
    public String getIntType() {
        return "INT";
    }

    @Override
    public String getTinyIntType() {
        return "TINYINT";
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getAutoIncrementClause() {
        return "AUTO_INCREMENT";
    }

    @Override
    public String getConcatSql(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string).append(" || ");
        }
        return stringBuffer.toString().replaceFirst(" \\|\\| $", "");
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    @Override
    public void setDatabaseChangeLogTableName(String string) {
        this.databaseChangeLogTableName = string;
    }

    @Override
    public void setDatabaseChangeLogLockTableName(String string) {
        this.databaseChangeLogLockTableName = string;
    }

    private SqlStatement getChangeLogLockInsertSQL() {
        return new InsertStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()).addColumnValue("ID", 1).addColumnValue("LOCKED", Boolean.FALSE);
    }

    protected SqlStatement getCreateChangeLogLockSQL() {
        return new CreateTableStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()).addPrimaryKeyColumn("ID", "INT", null, null, new NotNullConstraint()).addColumn("LOCKED", this.getBooleanType(), new NotNullConstraint()).addColumn("LOCKGRANTED", this.getDateTimeType()).addColumn("LOCKEDBY", "VARCHAR(255)");
    }

    protected SqlStatement getCreateChangeLogSQL() {
        return new CreateTableStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()).addPrimaryKeyColumn("ID", "VARCHAR(63)", null, null, new NotNullConstraint()).addPrimaryKeyColumn("AUTHOR", "VARCHAR(63)", null, null, new NotNullConstraint()).addPrimaryKeyColumn("FILENAME", "VARCHAR(200)", null, null, new NotNullConstraint()).addColumn("DATEEXECUTED", this.getDateTimeType(), new NotNullConstraint()).addColumn("MD5SUM", "VARCHAR(32)").addColumn("DESCRIPTION", "VARCHAR(255)").addColumn("COMMENTS", "VARCHAR(255)").addColumn("TAG", "VARCHAR(255)").addColumn("LIQUIBASE", "VARCHAR(10)");
    }

    @Override
    public SqlStatement getSelectChangeLogLockSQL() throws JDBCException {
        return new RawSqlStatement("SELECT LOCKED FROM " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()) + " WHERE " + this.escapeColumnName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName(), "ID") + "=1");
    }

    @Override
    public boolean doesChangeLogTableExist() throws JDBCException {
        DatabaseConnection databaseConnection = this.getConnection();
        ResultSet resultSet = null;
        try {
            resultSet = databaseConnection.getMetaData().getTables(this.convertRequestedSchemaToCatalog(this.getDefaultSchemaName()), this.convertRequestedSchemaToSchema(this.getDefaultSchemaName()), this.getDatabaseChangeLogTableName(), new String[]{"TABLE"});
            boolean bl = resultSet.next();
            return bl;
        }
        catch (Exception exception) {
            throw new JDBCException(exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    log.warning("Error closing result set: " + sQLException.getMessage());
                }
            }
        }
    }

    @Override
    public void checkDatabaseChangeLogTable() throws JDBCException {
        if (!this.getJdbcTemplate().executesStatements()) {
            if (((JdbcOutputTemplate)this.getJdbcTemplate()).alreadyCreatedChangeTable()) {
                return;
            }
            ((JdbcOutputTemplate)this.getJdbcTemplate()).setAlreadyCreatedChangeTable(true);
        }
        DatabaseConnection databaseConnection = this.getConnection();
        ResultSet resultSet = null;
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        boolean bl = false;
        try {
            if (this.doesChangeLogTableExist()) {
                resultSet = databaseConnection.getMetaData().getColumns(this.convertRequestedSchemaToCatalog(this.getDefaultSchemaName()), this.convertRequestedSchemaToSchema(this.getDefaultSchemaName()), this.getDatabaseChangeLogTableName(), null);
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                while (resultSet.next()) {
                    String string = resultSet.getString("COLUMN_NAME");
                    if ("DESCRIPTION".equalsIgnoreCase(string)) {
                        bl2 = true;
                        continue;
                    }
                    if ("COMMENTS".equalsIgnoreCase(string)) {
                        bl3 = true;
                        continue;
                    }
                    if ("TAG".equalsIgnoreCase(string)) {
                        bl4 = true;
                        continue;
                    }
                    if (!"LIQUIBASE".equalsIgnoreCase(string)) continue;
                    bl5 = true;
                }
                if (!bl2) {
                    arrayList.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "DESCRIPTION", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
                if (!bl4) {
                    arrayList.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "TAG", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
                if (!bl3) {
                    arrayList.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "COMMENTS", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
                if (!bl5) {
                    arrayList.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
            } else if (!bl) {
                this.getJdbcTemplate().comment("Create Database Change Log Table");
                SqlStatement sqlStatement = this.getCreateChangeLogSQL();
                if (!this.canCreateChangeLogTable()) {
                    throw new JDBCException("Cannot create " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " table for your database.\n\n" + "Please construct it manually using the following SQL as a base and re-run LiquiBase:\n\n" + sqlStatement);
                }
                arrayList.add(sqlStatement);
                log.info("Creating database history table with name: " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()));
            }
            for (SqlStatement sqlStatement : arrayList) {
                this.getJdbcTemplate().execute(sqlStatement, new ArrayList<SqlVisitor>());
                this.commit();
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw new JDBCException(sQLException);
                }
            }
        }
    }

    protected boolean canCreateChangeLogTable() throws JDBCException {
        return true;
    }

    @Override
    public boolean doesChangeLogLockTableExist() throws JDBCException {
        DatabaseConnection databaseConnection = this.getConnection();
        ResultSet resultSet = null;
        try {
            resultSet = databaseConnection.getMetaData().getTables(this.convertRequestedSchemaToCatalog(this.getDefaultSchemaName()), this.convertRequestedSchemaToSchema(this.getDefaultSchemaName()), this.getDatabaseChangeLogLockTableName(), new String[]{"TABLE"});
            boolean bl = resultSet.next();
            return bl;
        }
        catch (Exception exception) {
            throw new JDBCException(exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    log.warning("Error closing result set: " + sQLException.getMessage());
                }
            }
        }
    }

    @Override
    public void checkDatabaseChangeLogLockTable() throws JDBCException {
        boolean bl = false;
        if (!this.doesChangeLogLockTableExist()) {
            if (!this.getJdbcTemplate().executesStatements()) {
                if (((JdbcOutputTemplate)this.getJdbcTemplate()).alreadyCreatedChangeLockTable()) {
                    return;
                }
                ((JdbcOutputTemplate)this.getJdbcTemplate()).setAlreadyCreatedChangeLockTable(true);
            }
            SqlStatement sqlStatement = this.getCreateChangeLogLockSQL();
            this.getJdbcTemplate().comment("Create Database Lock Table");
            this.getJdbcTemplate().execute(sqlStatement, new ArrayList<SqlVisitor>());
            this.commit();
            log.finest("Created database lock table with name: " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()));
            bl = true;
        }
        int n = -1;
        if (!bl) {
            RawSqlStatement rawSqlStatement = new RawSqlStatement("SELECT COUNT(*) FROM " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()) + " WHERE ID=1");
            n = this.getJdbcTemplate().queryForInt(rawSqlStatement, new ArrayList<SqlVisitor>());
        }
        if (bl || n == 0) {
            this.getJdbcTemplate().update(this.getChangeLogLockInsertSQL(), new ArrayList<SqlVisitor>());
            this.commit();
            log.fine("Inserted lock row into: " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabaseObjects(String string) throws JDBCException {
        try {
            AbstractChange abstractChange;
            DatabaseSnapshot databaseSnapshot = this.createDatabaseSnapshot(string, new HashSet<DiffStatusListener>());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (View object : databaseSnapshot.getViews()) {
                abstractChange = new DropViewChange();
                ((DropViewChange)abstractChange).setViewName(object.getName());
                ((DropViewChange)abstractChange).setSchemaName(string);
                arrayList.add(abstractChange);
            }
            for (ForeignKey foreignKey : databaseSnapshot.getForeignKeys()) {
                abstractChange = new DropForeignKeyConstraintChange();
                ((DropForeignKeyConstraintChange)abstractChange).setBaseTableSchemaName(string);
                ((DropForeignKeyConstraintChange)abstractChange).setBaseTableName(foreignKey.getForeignKeyTable().getName());
                ((DropForeignKeyConstraintChange)abstractChange).setConstraintName(foreignKey.getName());
                arrayList.add(abstractChange);
            }
            for (Table table : databaseSnapshot.getTables()) {
                abstractChange = new DropTableChange();
                ((DropTableChange)abstractChange).setSchemaName(string);
                ((DropTableChange)abstractChange).setTableName(table.getName());
                ((DropTableChange)abstractChange).setCascadeConstraints(true);
                arrayList.add(abstractChange);
            }
            if (this.supportsSequences()) {
                for (Sequence sequence : databaseSnapshot.getSequences()) {
                    abstractChange = new DropSequenceChange();
                    ((DropSequenceChange)abstractChange).setSequenceName(sequence.getName());
                    ((DropSequenceChange)abstractChange).setSchemaName(string);
                    arrayList.add(abstractChange);
                }
            }
            if (databaseSnapshot.hasDatabaseChangeLogTable()) {
                Iterator iterator = new RawSQLChange();
                ((AbstractSQLChange)((Object)iterator)).setSql("DELETE FROM " + this.escapeTableName(this.convertRequestedSchemaToSchema(string), this.getDatabaseChangeLogTableName()));
                arrayList.add(iterator);
            }
            try {
                for (Change change : arrayList) {
                    for (AbstractChange abstractChange2 : change.generateStatements(this)) {
                        this.getJdbcTemplate().execute((SqlStatement)((Object)abstractChange2), new ArrayList<SqlVisitor>());
                    }
                }
            }
            catch (UnsupportedChangeException unsupportedChangeException) {
                throw new JDBCException(unsupportedChangeException);
            }
        }
        finally {
            this.commit();
        }
    }

    @Override
    public boolean isSystemTable(String string, String string2, String string3) {
        if ("information_schema".equalsIgnoreCase(string2)) {
            return true;
        }
        if (string3.equalsIgnoreCase(this.getDatabaseChangeLogLockTableName())) {
            return true;
        }
        return this.getSystemTablesAndViews().contains(string3);
    }

    @Override
    public boolean isSystemView(String string, String string2, String string3) {
        if ("information_schema".equalsIgnoreCase(string2)) {
            return true;
        }
        return this.getSystemTablesAndViews().contains(string3);
    }

    @Override
    public boolean isLiquibaseTable(String string) {
        return string.equalsIgnoreCase(this.getDatabaseChangeLogTableName()) || string.equalsIgnoreCase(this.getDatabaseChangeLogLockTableName());
    }

    @Override
    public void tag(String string) throws JDBCException {
        try {
            int n = this.getJdbcTemplate().queryForInt(new RawSqlStatement("SELECT COUNT(*) FROM " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())), new ArrayList<SqlVisitor>());
            if (n == 0) {
                throw new JDBCException("Cannot tag an empty database");
            }
            int n2 = this.getJdbcTemplate().update(new TagDatabaseStatement(string), new ArrayList<SqlVisitor>());
            if (n2 == 0) {
                throw new JDBCException("Did not tag database change log correctly");
            }
            this.commit();
        }
        catch (Exception exception) {
            throw new JDBCException(exception);
        }
    }

    @Override
    public SqlStatement createFindSequencesSQL(String string) throws JDBCException {
        return null;
    }

    @Override
    public boolean doesTagExist(String string) throws JDBCException {
        int n = this.getJdbcTemplate().queryForInt(new RawSqlStatement("SELECT COUNT(*) FROM " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " WHERE TAG='" + string + "'"), new ArrayList<SqlVisitor>());
        return n > 0;
    }

    public String toString() {
        if (this.getConnection() == null) {
            return this.getProductName() + " Database";
        }
        try {
            return this.getConnectionUsername() + " @ " + this.getConnectionURL() + (this.getDefaultSchemaName() == null ? "" : " (Default Schema: " + this.getDefaultSchemaName() + ")");
        }
        catch (JDBCException jDBCException) {
            return super.toString();
        }
    }

    @Override
    public boolean shouldQuoteValue(String string) {
        return true;
    }

    @Override
    public String getViewDefinition(String string, String string2) throws JDBCException {
        String string3;
        if (string == null) {
            string = this.convertRequestedSchemaToSchema(null);
        }
        if ((string3 = (String)this.getJdbcTemplate().queryForObject(this.getViewDefinitionSql(string, string2), String.class, new ArrayList<SqlVisitor>())) == null) {
            return null;
        }
        return CREATE_VIEW_AS_PATTERN.matcher(string3).replaceFirst("");
    }

    public SqlStatement getViewDefinitionSql(String string, String string2) throws JDBCException {
        String string3 = "select view_definition from information_schema.views where upper(table_name)='" + string2.toUpperCase() + "'";
        if (this.convertRequestedSchemaToCatalog(string) != null) {
            string3 = string3 + " and table_schema='" + this.convertRequestedSchemaToSchema(string) + "'";
        } else if (this.convertRequestedSchemaToCatalog(string) != null) {
            string3 = string3 + " and table_catalog='" + this.convertRequestedSchemaToCatalog(string) + "'";
        }
        log.finest("GetViewDefinitionSQL: " + string3);
        return new RawSqlStatement(string3);
    }

    @Override
    public int getDatabaseType(int n) {
        String string;
        int n2 = n;
        if (n2 == 16 && !(string = this.getBooleanType()).equalsIgnoreCase("boolean")) {
            n2 = -6;
        }
        return n2;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object object, int n, int n2, int n3) throws ParseException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.convertToCorrectJavaType(((String)object).replaceFirst("^'", "").replaceFirst("'$", ""), n, n2, n3);
        }
        return object;
    }

    protected Object convertToCorrectJavaType(String string, int n, int n2, int n3) throws ParseException {
        if (string == null) {
            return null;
        }
        if (n == 2005 || n == 12 || n == 1 || n == -1) {
            if (string.equalsIgnoreCase("NULL")) {
                return null;
            }
            return string;
        }
        if ((string = StringUtils.trimToNull(string)) == null) {
            return null;
        }
        try {
            if (n == 91) {
                return new Date(this.parseDate(string).getTime());
            }
            if (n == 93) {
                return new Timestamp(this.parseDate(string).getTime());
            }
            if (n == 92) {
                return new Time(this.parseDate(string).getTime());
            }
            if (n == -5) {
                return new BigInteger(string);
            }
            if (n == -7) {
                if ((string = string.replaceFirst("b'", "")).equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (string.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                if (string.equals("1")) {
                    return Boolean.TRUE;
                }
                if (string.equals("0")) {
                    return Boolean.FALSE;
                }
                if (string.equals("(1)")) {
                    return Boolean.TRUE;
                }
                if (string.equals("(0)")) {
                    return Boolean.FALSE;
                }
                throw new ParseException("Unknown bit value: " + string, 0);
            }
            if (n == 16) {
                return Boolean.valueOf(string);
            }
            if (n == 3) {
                if (n3 == 0) {
                    return new Integer(string);
                }
                return new Double(string);
            }
            if (n == 8 || n == 2) {
                return new Double(string);
            }
            if (n == 6) {
                return new Float(string);
            }
            if (n == 4) {
                return new Integer(string);
            }
            if (n == 0) {
                return null;
            }
            if (n == 7) {
                return new Float(string);
            }
            if (n == 5) {
                return new Integer(string);
            }
            if (n == -6) {
                return new Integer(string);
            }
            if (n == 2004) {
                return "!!!!!! LIQUIBASE CANNOT OUTPUT BLOB VALUES !!!!!!";
            }
            log.warning("Do not know how to convert type " + n);
            return string;
        }
        catch (DateParseException dateParseException) {
            return new ComputedDateValue(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new ComputedNumericValue(string);
        }
    }

    @Override
    public String convertJavaObjectToString(Object object) {
        if (object != null) {
            if (object instanceof String) {
                if ("null".equalsIgnoreCase((String)object)) {
                    return null;
                }
                return "'" + ((String)object).replaceAll("'", "''") + "'";
            }
            if (object instanceof Number) {
                return object.toString();
            }
            if (object instanceof Boolean) {
                String string = (Boolean)object != false ? this.getTrueBooleanValue() : this.getFalseBooleanValue();
                if (string.matches("\\d+")) {
                    return string;
                }
                return "'" + string + "'";
            }
            if (object instanceof Date) {
                return this.getDateLiteral((Date)object);
            }
            if (object instanceof Time) {
                return this.getDateLiteral((Time)object);
            }
            if (object instanceof Timestamp) {
                return this.getDateLiteral((Timestamp)object);
            }
            if (object instanceof ComputedDateValue) {
                return ((ComputedDateValue)object).getValue();
            }
            throw new RuntimeException("Unknown default value type: " + object.getClass().getName());
        }
        return null;
    }

    @Override
    public String escapeTableName(String string, String string2) {
        if (StringUtils.trimToNull(string) == null || !this.supportsSchemas()) {
            return this.getObjectEscapeCharacter() + string2 + this.getObjectEscapeCharacter();
        }
        return this.getObjectEscapeCharacter() + string + this.getObjectEscapeCharacter() + "." + this.getObjectEscapeCharacter() + string2 + this.getObjectEscapeCharacter();
    }

    public String getObjectEscapeCharacter() {
        return "";
    }

    @Override
    public String escapeIndexName(String string, String string2) {
        return this.escapeTableName(string, string2);
    }

    @Override
    public String escapeSequenceName(String string, String string2) {
        if (StringUtils.trimToNull(string) == null || !this.supportsSchemas()) {
            return this.getObjectEscapeCharacter() + string2 + this.getObjectEscapeCharacter();
        }
        return this.getObjectEscapeCharacter() + string + this.getObjectEscapeCharacter() + "." + this.getObjectEscapeCharacter() + string2 + this.getObjectEscapeCharacter();
    }

    @Override
    public String escapeConstraintName(String string) {
        return this.getObjectEscapeCharacter() + string + this.getObjectEscapeCharacter();
    }

    @Override
    public String escapeColumnName(String string, String string2, String string3) {
        return this.getObjectEscapeCharacter() + string3 + this.getObjectEscapeCharacter();
    }

    @Override
    public String escapeColumnNameList(String string) {
        return string;
    }

    @Override
    public String convertRequestedSchemaToCatalog(String string) throws JDBCException {
        if (this.getDefaultCatalogName() == null) {
            return null;
        }
        if (string == null) {
            return this.getDefaultCatalogName();
        }
        return StringUtils.trimToNull(string);
    }

    @Override
    public String convertRequestedSchemaToSchema(String string) throws JDBCException {
        String string2 = string;
        if (string2 == null) {
            string2 = this.getDefaultDatabaseSchemaName();
        }
        if (string2 != null) {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public String generatePrimaryKeyName(String string) {
        return "PK_" + string.toUpperCase();
    }

    @Override
    public String escapeViewName(String string, String string2) {
        return this.escapeTableName(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isColumnAutoIncrement(String string, String string2, String string3) throws SQLException, JDBCException {
        if (!this.supportsAutoIncrement()) {
            return false;
        }
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().createStatement().executeQuery("SELECT " + this.escapeColumnName(string, string2, string3) + " FROM " + this.escapeTableName(string, string2) + " WHERE 1 = 0");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            bl = resultSetMetaData.isAutoIncrement(1);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return bl;
    }

    @Override
    public ChangeSet.RunStatus getRunStatus(ChangeSet changeSet) throws JDBCException, DatabaseHistoryException {
        if (!this.doesChangeLogTableExist()) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        RanChangeSet ranChangeSet = this.getRanChangeSet(changeSet);
        if (ranChangeSet == null) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        if (ranChangeSet.getMd5sum() == null) {
            try {
                log.info("Updating NULL md5sum for " + changeSet.toString());
                DatabaseConnection databaseConnection = this.getConnection();
                PreparedStatement preparedStatement = databaseConnection.prepareStatement("UPDATE " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM=? WHERE ID=? AND AUTHOR=? AND FILENAME=?");
                preparedStatement.setString(1, changeSet.getMd5sum());
                preparedStatement.setString(2, changeSet.getId());
                preparedStatement.setString(3, changeSet.getAuthor());
                preparedStatement.setString(4, changeSet.getFilePath());
                preparedStatement.executeUpdate();
                preparedStatement.close();
                this.commit();
            }
            catch (SQLException sQLException) {
                throw new JDBCException(sQLException);
            }
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (ranChangeSet.getMd5sum().equals(changeSet.getMd5sum())) {
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (changeSet.shouldRunOnChange()) {
            return ChangeSet.RunStatus.RUN_AGAIN;
        }
        return ChangeSet.RunStatus.INVALID_MD5SUM;
    }

    @Override
    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws JDBCException, DatabaseHistoryException {
        if (!this.doesChangeLogTableExist()) {
            throw new DatabaseHistoryException("Database change table does not exist");
        }
        RanChangeSet ranChangeSet = null;
        for (RanChangeSet ranChangeSet2 : this.getRanChangeSetList()) {
            if (!ranChangeSet2.isSameAs(changeSet)) continue;
            ranChangeSet = ranChangeSet2;
            break;
        }
        return ranChangeSet;
    }

    @Override
    public List<RanChangeSet> getRanChangeSetList() throws JDBCException {
        if (this.ranChangeSetList != null) {
            return this.ranChangeSetList;
        }
        try {
            String string = this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName());
            this.ranChangeSetList = new ArrayList<RanChangeSet>();
            if (this.doesChangeLogTableExist()) {
                log.info("Reading from " + string);
                String string2 = "SELECT * FROM " + string + " ORDER BY DATEEXECUTED ASC".toUpperCase();
                Statement statement = this.getConnection().createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    String string3 = resultSet.getString("FILENAME");
                    String string4 = resultSet.getString("AUTHOR");
                    String string5 = resultSet.getString("ID");
                    String string6 = resultSet.getString("MD5SUM");
                    Timestamp timestamp = resultSet.getTimestamp("DATEEXECUTED");
                    String string7 = resultSet.getString("TAG");
                    RanChangeSet ranChangeSet = new RanChangeSet(string3, string5, string4, string6, timestamp, string7);
                    this.ranChangeSetList.add(ranChangeSet);
                }
                resultSet.close();
                statement.close();
            }
            return this.ranChangeSetList;
        }
        catch (SQLException sQLException) {
            if (!this.getJdbcTemplate().executesStatements()) {
                return new ArrayList<RanChangeSet>();
            }
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public java.util.Date getRanDate(ChangeSet changeSet) throws JDBCException, DatabaseHistoryException {
        RanChangeSet ranChangeSet = this.getRanChangeSet(changeSet);
        if (ranChangeSet == null) {
            return null;
        }
        return ranChangeSet.getDateExecuted();
    }

    @Override
    public void markChangeSetAsRan(ChangeSet changeSet) throws JDBCException {
        String string = this.getCurrentDateTimeFunction();
        InsertStatement insertStatement = new InsertStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName());
        insertStatement.addColumnValue("ID", this.escapeStringForDatabase(changeSet.getId()));
        insertStatement.addColumnValue("AUTHOR", changeSet.getAuthor());
        insertStatement.addColumnValue("FILENAME", changeSet.getFilePath());
        insertStatement.addColumnValue("DATEEXECUTED", new ComputedDateValue(string));
        insertStatement.addColumnValue("MD5SUM", changeSet.getMd5sum());
        insertStatement.addColumnValue("DESCRIPTION", this.limitSize(changeSet.getDescription()));
        insertStatement.addColumnValue("COMMENTS", this.limitSize(StringUtils.trimToEmpty(changeSet.getComments())));
        insertStatement.addColumnValue("LIQUIBASE", LiquibaseUtil.getBuildVersion());
        this.getJdbcTemplate().execute(insertStatement, new ArrayList<SqlVisitor>());
        this.getRanChangeSetList().add(new RanChangeSet(changeSet));
    }

    @Override
    public void markChangeSetAsReRan(ChangeSet changeSet) throws JDBCException {
        String string = this.getCurrentDateTimeFunction();
        String string2 = "UPDATE " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " SET DATEEXECUTED=" + string + ", MD5SUM='?' WHERE ID='?' AND AUTHOR='?' AND FILENAME='?'";
        string2 = string2.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getMd5sum()));
        string2 = string2.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getId()));
        string2 = string2.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getAuthor()));
        string2 = string2.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getFilePath()));
        this.getJdbcTemplate().execute(new RawSqlStatement(string2), new ArrayList<SqlVisitor>());
        this.commit();
    }

    @Override
    public void removeRanStatus(ChangeSet changeSet) throws JDBCException {
        String string = "DELETE FROM " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " WHERE ID='?' AND AUTHOR='?' AND FILENAME='?'";
        string = string.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getId()));
        string = string.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getAuthor()));
        string = string.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getFilePath()));
        this.getJdbcTemplate().execute(new RawSqlStatement(string), new ArrayList<SqlVisitor>());
        this.commit();
        this.getRanChangeSetList().remove(new RanChangeSet(changeSet));
    }

    @Override
    public String escapeStringForDatabase(String string) {
        return string.replaceAll("'", "''");
    }

    private String limitSize(String string) {
        int n = 255;
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    @Override
    public void commit() throws JDBCException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public void rollback() throws JDBCException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        if (this.jdbcTemplate != null && !this.jdbcTemplate.executesStatements() && jdbcTemplate.executesStatements()) {
            LockHandler.getInstance(this).reset();
        }
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractDatabase abstractDatabase = (AbstractDatabase)object;
        return !(this.connection == null ? abstractDatabase.connection != null : !this.connection.equals(abstractDatabase.connection));
    }

    public int hashCode() {
        return this.connection != null ? this.connection.hashCode() : 0;
    }

    @Override
    public void close() throws JDBCException {
        try {
            DatabaseConnection databaseConnection = this.getConnection();
            if (databaseConnection != null) {
                databaseConnection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public abstract DatabaseSnapshot createDatabaseSnapshot(String var1, Set<DiffStatusListener> var2) throws JDBCException;

    @Override
    public boolean supportsRestrictForeignKeys() {
        return true;
    }

    @Override
    public boolean isAutoCommit() throws JDBCException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws JDBCException {
        try {
            this.getConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
    }

    @Override
    public boolean isLocalDatabase() throws JDBCException {
        String string = this.getConnectionURL();
        return string.indexOf("localhost") >= 0 || string.indexOf("127.0.0.1") >= 0;
    }
}

