/*
 * Decompiled with CFR 0.152.
 */
package liquibase.csv.opencsv.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import liquibase.csv.opencsv.CSVReader;
import liquibase.csv.opencsv.bean.MappingStrategy;

public class HeaderColumnNameMappingStrategy
implements MappingStrategy {
    protected String[] header;
    protected PropertyDescriptor[] descriptors;
    protected Class type;

    public void captureHeader(CSVReader cSVReader) throws IOException {
        this.header = cSVReader.readNext();
    }

    public PropertyDescriptor findDescriptor(int n) throws IntrospectionException {
        String string = this.getColumnName(n);
        return null != string && string.trim().length() > 0 ? this.findDescriptor(string) : null;
    }

    protected String getColumnName(int n) {
        return null != this.header && n < this.header.length ? this.header[n] : null;
    }

    protected PropertyDescriptor findDescriptor(String string) throws IntrospectionException {
        if (null == this.descriptors) {
            this.descriptors = this.loadDescriptors(this.getType());
        }
        for (int i = 0; i < this.descriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = this.descriptors[i];
            if (!this.matches(string, propertyDescriptor)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    protected boolean matches(String string, PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().equals(string);
    }

    protected PropertyDescriptor[] loadDescriptors(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    public Object createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class clazz) {
        this.type = clazz;
    }
}

